/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DnsResolverListCopier;
import software.amazon.awssdk.services.quicksight.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.services.quicksight.model.SubnetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetBundleImportJobVPCConnectionOverrideParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetBundleImportJobVPCConnectionOverrideParameters> {
    private static final SdkField<String> VPC_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VPCConnectionId").getter(AssetBundleImportJobVPCConnectionOverrideParameters.getter(AssetBundleImportJobVPCConnectionOverrideParameters::vpcConnectionId)).setter(AssetBundleImportJobVPCConnectionOverrideParameters.setter(Builder::vpcConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCConnectionId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AssetBundleImportJobVPCConnectionOverrideParameters.getter(AssetBundleImportJobVPCConnectionOverrideParameters::name)).setter(AssetBundleImportJobVPCConnectionOverrideParameters.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(AssetBundleImportJobVPCConnectionOverrideParameters.getter(AssetBundleImportJobVPCConnectionOverrideParameters::subnetIds)).setter(AssetBundleImportJobVPCConnectionOverrideParameters.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(AssetBundleImportJobVPCConnectionOverrideParameters.getter(AssetBundleImportJobVPCConnectionOverrideParameters::securityGroupIds)).setter(AssetBundleImportJobVPCConnectionOverrideParameters.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DNS_RESOLVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsResolvers").getter(AssetBundleImportJobVPCConnectionOverrideParameters.getter(AssetBundleImportJobVPCConnectionOverrideParameters::dnsResolvers)).setter(AssetBundleImportJobVPCConnectionOverrideParameters.setter(Builder::dnsResolvers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsResolvers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(AssetBundleImportJobVPCConnectionOverrideParameters.getter(AssetBundleImportJobVPCConnectionOverrideParameters::roleArn)).setter(AssetBundleImportJobVPCConnectionOverrideParameters.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTION_ID_FIELD, NAME_FIELD, SUBNET_IDS_FIELD, SECURITY_GROUP_IDS_FIELD, DNS_RESOLVERS_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String vpcConnectionId;
    private final String name;
    private final List<String> subnetIds;
    private final List<String> securityGroupIds;
    private final List<String> dnsResolvers;
    private final String roleArn;

    private AssetBundleImportJobVPCConnectionOverrideParameters(BuilderImpl builder) {
        this.vpcConnectionId = builder.vpcConnectionId;
        this.name = builder.name;
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.dnsResolvers = builder.dnsResolvers;
        this.roleArn = builder.roleArn;
    }

    public final String vpcConnectionId() {
        return this.vpcConnectionId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasDnsResolvers() {
        return this.dnsResolvers != null && !(this.dnsResolvers instanceof SdkAutoConstructList);
    }

    public final List<String> dnsResolvers() {
        return this.dnsResolvers;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsResolvers() ? this.dnsResolvers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobVPCConnectionOverrideParameters)) {
            return false;
        }
        AssetBundleImportJobVPCConnectionOverrideParameters other = (AssetBundleImportJobVPCConnectionOverrideParameters)obj;
        return Objects.equals(this.vpcConnectionId(), other.vpcConnectionId()) && Objects.equals(this.name(), other.name()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasDnsResolvers() == other.hasDnsResolvers() && Objects.equals(this.dnsResolvers(), other.dnsResolvers()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"AssetBundleImportJobVPCConnectionOverrideParameters").add("VPCConnectionId", (Object)this.vpcConnectionId()).add("Name", (Object)this.name()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("DnsResolvers", this.hasDnsResolvers() ? this.dnsResolvers() : null).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VPCConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "DnsResolvers": {
                return Optional.ofNullable(clazz.cast(this.dnsResolvers()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobVPCConnectionOverrideParameters, T> g) {
        return obj -> g.apply((AssetBundleImportJobVPCConnectionOverrideParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcConnectionId;
        private String name;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> dnsResolvers = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobVPCConnectionOverrideParameters model) {
            this.vpcConnectionId(model.vpcConnectionId);
            this.name(model.name);
            this.subnetIds(model.subnetIds);
            this.securityGroupIds(model.securityGroupIds);
            this.dnsResolvers(model.dnsResolvers);
            this.roleArn(model.roleArn);
        }

        public final String getVpcConnectionId() {
            return this.vpcConnectionId;
        }

        public final void setVpcConnectionId(String vpcConnectionId) {
            this.vpcConnectionId = vpcConnectionId;
        }

        @Override
        public final Builder vpcConnectionId(String vpcConnectionId) {
            this.vpcConnectionId = vpcConnectionId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getDnsResolvers() {
            if (this.dnsResolvers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsResolvers;
        }

        public final void setDnsResolvers(Collection<String> dnsResolvers) {
            this.dnsResolvers = DnsResolverListCopier.copy(dnsResolvers);
        }

        @Override
        public final Builder dnsResolvers(Collection<String> dnsResolvers) {
            this.dnsResolvers = DnsResolverListCopier.copy(dnsResolvers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsResolvers(String ... dnsResolvers) {
            this.dnsResolvers(Arrays.asList(dnsResolvers));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public AssetBundleImportJobVPCConnectionOverrideParameters build() {
            return new AssetBundleImportJobVPCConnectionOverrideParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetBundleImportJobVPCConnectionOverrideParameters> {
        public Builder vpcConnectionId(String var1);

        public Builder name(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder dnsResolvers(Collection<String> var1);

        public Builder dnsResolvers(String ... var1);

        public Builder roleArn(String var1);
    }
}

