/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.Group;
import software.amazon.awssdk.services.quicksight.model.SearchGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchGroupsResponse;

public class SearchGroupsIterable
implements SdkIterable<SearchGroupsResponse> {
    private final QuickSightClient client;
    private final SearchGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchGroupsIterable(QuickSightClient client, SearchGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchGroupsResponseFetcher();
    }

    public Iterator<SearchGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Group> groupList() {
        Function<SearchGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groupList() != null) {
                return response.groupList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchGroupsResponseFetcher
    implements SyncPageFetcher<SearchGroupsResponse> {
        private SearchGroupsResponseFetcher() {
        }

        public boolean hasNextPage(SearchGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchGroupsResponse nextPage(SearchGroupsResponse previousPage) {
            if (previousPage == null) {
                return SearchGroupsIterable.this.client.searchGroups(SearchGroupsIterable.this.firstRequest);
            }
            return SearchGroupsIterable.this.client.searchGroups((SearchGroupsRequest)((Object)SearchGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

