/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The border options for a table border.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableBorderOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<TableBorderOptions.Builder, TableBorderOptions> {
    private static final SdkField<String> COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Color")
            .getter(getter(TableBorderOptions::color)).setter(setter(Builder::color))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()).build();

    private static final SdkField<Integer> THICKNESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Thickness").getter(getter(TableBorderOptions::thickness)).setter(setter(Builder::thickness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Thickness").build()).build();

    private static final SdkField<String> STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Style")
            .getter(getter(TableBorderOptions::styleAsString)).setter(setter(Builder::style))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Style").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLOR_FIELD, THICKNESS_FIELD,
            STYLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String color;

    private final Integer thickness;

    private final String style;

    private TableBorderOptions(BuilderImpl builder) {
        this.color = builder.color;
        this.thickness = builder.thickness;
        this.style = builder.style;
    }

    /**
     * <p>
     * The color of a table border.
     * </p>
     * 
     * @return The color of a table border.
     */
    public final String color() {
        return color;
    }

    /**
     * <p>
     * The thickness of a table border.
     * </p>
     * 
     * @return The thickness of a table border.
     */
    public final Integer thickness() {
        return thickness;
    }

    /**
     * <p>
     * The style (none, solid) of a table border.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #style} will return
     * {@link TableBorderStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #styleAsString}.
     * </p>
     * 
     * @return The style (none, solid) of a table border.
     * @see TableBorderStyle
     */
    public final TableBorderStyle style() {
        return TableBorderStyle.fromValue(style);
    }

    /**
     * <p>
     * The style (none, solid) of a table border.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #style} will return
     * {@link TableBorderStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #styleAsString}.
     * </p>
     * 
     * @return The style (none, solid) of a table border.
     * @see TableBorderStyle
     */
    public final String styleAsString() {
        return style;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(color());
        hashCode = 31 * hashCode + Objects.hashCode(thickness());
        hashCode = 31 * hashCode + Objects.hashCode(styleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableBorderOptions)) {
            return false;
        }
        TableBorderOptions other = (TableBorderOptions) obj;
        return Objects.equals(color(), other.color()) && Objects.equals(thickness(), other.thickness())
                && Objects.equals(styleAsString(), other.styleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableBorderOptions").add("Color", color()).add("Thickness", thickness())
                .add("Style", styleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Color":
            return Optional.ofNullable(clazz.cast(color()));
        case "Thickness":
            return Optional.ofNullable(clazz.cast(thickness()));
        case "Style":
            return Optional.ofNullable(clazz.cast(styleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableBorderOptions, T> g) {
        return obj -> g.apply((TableBorderOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableBorderOptions> {
        /**
         * <p>
         * The color of a table border.
         * </p>
         * 
         * @param color
         *        The color of a table border.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder color(String color);

        /**
         * <p>
         * The thickness of a table border.
         * </p>
         * 
         * @param thickness
         *        The thickness of a table border.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thickness(Integer thickness);

        /**
         * <p>
         * The style (none, solid) of a table border.
         * </p>
         * 
         * @param style
         *        The style (none, solid) of a table border.
         * @see TableBorderStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableBorderStyle
         */
        Builder style(String style);

        /**
         * <p>
         * The style (none, solid) of a table border.
         * </p>
         * 
         * @param style
         *        The style (none, solid) of a table border.
         * @see TableBorderStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableBorderStyle
         */
        Builder style(TableBorderStyle style);
    }

    static final class BuilderImpl implements Builder {
        private String color;

        private Integer thickness;

        private String style;

        private BuilderImpl() {
        }

        private BuilderImpl(TableBorderOptions model) {
            color(model.color);
            thickness(model.thickness);
            style(model.style);
        }

        public final String getColor() {
            return color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final Integer getThickness() {
            return thickness;
        }

        public final void setThickness(Integer thickness) {
            this.thickness = thickness;
        }

        @Override
        public final Builder thickness(Integer thickness) {
            this.thickness = thickness;
            return this;
        }

        public final String getStyle() {
            return style;
        }

        public final void setStyle(String style) {
            this.style = style;
        }

        @Override
        public final Builder style(String style) {
            this.style = style;
            return this;
        }

        @Override
        public final Builder style(TableBorderStyle style) {
            this.style(style == null ? null : style.toString());
            return this;
        }

        @Override
        public TableBorderOptions build() {
            return new TableBorderOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
