/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The sort configuration of a scatter plot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScatterPlotSortConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ScatterPlotSortConfiguration.Builder, ScatterPlotSortConfiguration> {
    private static final SdkField<ItemsLimitConfiguration> SCATTER_PLOT_LIMIT_CONFIGURATION_FIELD = SdkField
            .<ItemsLimitConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ScatterPlotLimitConfiguration")
            .getter(getter(ScatterPlotSortConfiguration::scatterPlotLimitConfiguration))
            .setter(setter(Builder::scatterPlotLimitConfiguration))
            .constructor(ItemsLimitConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScatterPlotLimitConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SCATTER_PLOT_LIMIT_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ItemsLimitConfiguration scatterPlotLimitConfiguration;

    private ScatterPlotSortConfiguration(BuilderImpl builder) {
        this.scatterPlotLimitConfiguration = builder.scatterPlotLimitConfiguration;
    }

    /**
     * Returns the value of the ScatterPlotLimitConfiguration property for this object.
     * 
     * @return The value of the ScatterPlotLimitConfiguration property for this object.
     */
    public final ItemsLimitConfiguration scatterPlotLimitConfiguration() {
        return scatterPlotLimitConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scatterPlotLimitConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScatterPlotSortConfiguration)) {
            return false;
        }
        ScatterPlotSortConfiguration other = (ScatterPlotSortConfiguration) obj;
        return Objects.equals(scatterPlotLimitConfiguration(), other.scatterPlotLimitConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScatterPlotSortConfiguration")
                .add("ScatterPlotLimitConfiguration", scatterPlotLimitConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScatterPlotLimitConfiguration":
            return Optional.ofNullable(clazz.cast(scatterPlotLimitConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScatterPlotSortConfiguration, T> g) {
        return obj -> g.apply((ScatterPlotSortConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScatterPlotSortConfiguration> {
        /**
         * Sets the value of the ScatterPlotLimitConfiguration property for this object.
         *
         * @param scatterPlotLimitConfiguration
         *        The new value for the ScatterPlotLimitConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scatterPlotLimitConfiguration(ItemsLimitConfiguration scatterPlotLimitConfiguration);

        /**
         * Sets the value of the ScatterPlotLimitConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ItemsLimitConfiguration.Builder} avoiding
         * the need to create one manually via {@link ItemsLimitConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ItemsLimitConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #scatterPlotLimitConfiguration(ItemsLimitConfiguration)}.
         * 
         * @param scatterPlotLimitConfiguration
         *        a consumer that will call methods on {@link ItemsLimitConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scatterPlotLimitConfiguration(ItemsLimitConfiguration)
         */
        default Builder scatterPlotLimitConfiguration(Consumer<ItemsLimitConfiguration.Builder> scatterPlotLimitConfiguration) {
            return scatterPlotLimitConfiguration(ItemsLimitConfiguration.builder().applyMutation(scatterPlotLimitConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ItemsLimitConfiguration scatterPlotLimitConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ScatterPlotSortConfiguration model) {
            scatterPlotLimitConfiguration(model.scatterPlotLimitConfiguration);
        }

        public final ItemsLimitConfiguration.Builder getScatterPlotLimitConfiguration() {
            return scatterPlotLimitConfiguration != null ? scatterPlotLimitConfiguration.toBuilder() : null;
        }

        public final void setScatterPlotLimitConfiguration(ItemsLimitConfiguration.BuilderImpl scatterPlotLimitConfiguration) {
            this.scatterPlotLimitConfiguration = scatterPlotLimitConfiguration != null ? scatterPlotLimitConfiguration.build()
                    : null;
        }

        @Override
        public final Builder scatterPlotLimitConfiguration(ItemsLimitConfiguration scatterPlotLimitConfiguration) {
            this.scatterPlotLimitConfiguration = scatterPlotLimitConfiguration;
            return this;
        }

        @Override
        public ScatterPlotSortConfiguration build() {
            return new ScatterPlotSortConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
