/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines the row alternate color options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RowAlternateColorOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<RowAlternateColorOptions.Builder, RowAlternateColorOptions> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RowAlternateColorOptions::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<String>> ROW_ALTERNATE_COLORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RowAlternateColors")
            .getter(getter(RowAlternateColorOptions::rowAlternateColors))
            .setter(setter(Builder::rowAlternateColors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowAlternateColors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USE_PRIMARY_BACKGROUND_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsePrimaryBackgroundColor").getter(getter(RowAlternateColorOptions::usePrimaryBackgroundColorAsString))
            .setter(setter(Builder::usePrimaryBackgroundColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsePrimaryBackgroundColor").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            ROW_ALTERNATE_COLORS_FIELD, USE_PRIMARY_BACKGROUND_COLOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final List<String> rowAlternateColors;

    private final String usePrimaryBackgroundColor;

    private RowAlternateColorOptions(BuilderImpl builder) {
        this.status = builder.status;
        this.rowAlternateColors = builder.rowAlternateColors;
        this.usePrimaryBackgroundColor = builder.usePrimaryBackgroundColor;
    }

    /**
     * <p>
     * Determines the widget status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WidgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Determines the widget status.
     * @see WidgetStatus
     */
    public final WidgetStatus status() {
        return WidgetStatus.fromValue(status);
    }

    /**
     * <p>
     * Determines the widget status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WidgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Determines the widget status.
     * @see WidgetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the RowAlternateColors property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRowAlternateColors() {
        return rowAlternateColors != null && !(rowAlternateColors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Determines the list of row alternate colors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRowAlternateColors} method.
     * </p>
     * 
     * @return Determines the list of row alternate colors.
     */
    public final List<String> rowAlternateColors() {
        return rowAlternateColors;
    }

    /**
     * <p>
     * The primary background color options for alternate rows.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #usePrimaryBackgroundColor} will return {@link WidgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #usePrimaryBackgroundColorAsString}.
     * </p>
     * 
     * @return The primary background color options for alternate rows.
     * @see WidgetStatus
     */
    public final WidgetStatus usePrimaryBackgroundColor() {
        return WidgetStatus.fromValue(usePrimaryBackgroundColor);
    }

    /**
     * <p>
     * The primary background color options for alternate rows.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #usePrimaryBackgroundColor} will return {@link WidgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #usePrimaryBackgroundColorAsString}.
     * </p>
     * 
     * @return The primary background color options for alternate rows.
     * @see WidgetStatus
     */
    public final String usePrimaryBackgroundColorAsString() {
        return usePrimaryBackgroundColor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRowAlternateColors() ? rowAlternateColors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(usePrimaryBackgroundColorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowAlternateColorOptions)) {
            return false;
        }
        RowAlternateColorOptions other = (RowAlternateColorOptions) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && hasRowAlternateColors() == other.hasRowAlternateColors()
                && Objects.equals(rowAlternateColors(), other.rowAlternateColors())
                && Objects.equals(usePrimaryBackgroundColorAsString(), other.usePrimaryBackgroundColorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RowAlternateColorOptions").add("Status", statusAsString())
                .add("RowAlternateColors", hasRowAlternateColors() ? rowAlternateColors() : null)
                .add("UsePrimaryBackgroundColor", usePrimaryBackgroundColorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "RowAlternateColors":
            return Optional.ofNullable(clazz.cast(rowAlternateColors()));
        case "UsePrimaryBackgroundColor":
            return Optional.ofNullable(clazz.cast(usePrimaryBackgroundColorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RowAlternateColorOptions, T> g) {
        return obj -> g.apply((RowAlternateColorOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RowAlternateColorOptions> {
        /**
         * <p>
         * Determines the widget status.
         * </p>
         * 
         * @param status
         *        Determines the widget status.
         * @see WidgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WidgetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Determines the widget status.
         * </p>
         * 
         * @param status
         *        Determines the widget status.
         * @see WidgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WidgetStatus
         */
        Builder status(WidgetStatus status);

        /**
         * <p>
         * Determines the list of row alternate colors.
         * </p>
         * 
         * @param rowAlternateColors
         *        Determines the list of row alternate colors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowAlternateColors(Collection<String> rowAlternateColors);

        /**
         * <p>
         * Determines the list of row alternate colors.
         * </p>
         * 
         * @param rowAlternateColors
         *        Determines the list of row alternate colors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowAlternateColors(String... rowAlternateColors);

        /**
         * <p>
         * The primary background color options for alternate rows.
         * </p>
         * 
         * @param usePrimaryBackgroundColor
         *        The primary background color options for alternate rows.
         * @see WidgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WidgetStatus
         */
        Builder usePrimaryBackgroundColor(String usePrimaryBackgroundColor);

        /**
         * <p>
         * The primary background color options for alternate rows.
         * </p>
         * 
         * @param usePrimaryBackgroundColor
         *        The primary background color options for alternate rows.
         * @see WidgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WidgetStatus
         */
        Builder usePrimaryBackgroundColor(WidgetStatus usePrimaryBackgroundColor);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private List<String> rowAlternateColors = DefaultSdkAutoConstructList.getInstance();

        private String usePrimaryBackgroundColor;

        private BuilderImpl() {
        }

        private BuilderImpl(RowAlternateColorOptions model) {
            status(model.status);
            rowAlternateColors(model.rowAlternateColors);
            usePrimaryBackgroundColor(model.usePrimaryBackgroundColor);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WidgetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getRowAlternateColors() {
            if (rowAlternateColors instanceof SdkAutoConstructList) {
                return null;
            }
            return rowAlternateColors;
        }

        public final void setRowAlternateColors(Collection<String> rowAlternateColors) {
            this.rowAlternateColors = RowAlternateColorListCopier.copy(rowAlternateColors);
        }

        @Override
        public final Builder rowAlternateColors(Collection<String> rowAlternateColors) {
            this.rowAlternateColors = RowAlternateColorListCopier.copy(rowAlternateColors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowAlternateColors(String... rowAlternateColors) {
            rowAlternateColors(Arrays.asList(rowAlternateColors));
            return this;
        }

        public final String getUsePrimaryBackgroundColor() {
            return usePrimaryBackgroundColor;
        }

        public final void setUsePrimaryBackgroundColor(String usePrimaryBackgroundColor) {
            this.usePrimaryBackgroundColor = usePrimaryBackgroundColor;
        }

        @Override
        public final Builder usePrimaryBackgroundColor(String usePrimaryBackgroundColor) {
            this.usePrimaryBackgroundColor = usePrimaryBackgroundColor;
            return this;
        }

        @Override
        public final Builder usePrimaryBackgroundColor(WidgetStatus usePrimaryBackgroundColor) {
            this.usePrimaryBackgroundColor(usePrimaryBackgroundColor == null ? null : usePrimaryBackgroundColor.toString());
            return this;
        }

        @Override
        public RowAlternateColorOptions build() {
            return new RowAlternateColorOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
