/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The refresh configuration of a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RefreshConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RefreshConfiguration.Builder, RefreshConfiguration> {
    private static final SdkField<IncrementalRefresh> INCREMENTAL_REFRESH_FIELD = SdkField
            .<IncrementalRefresh> builder(MarshallingType.SDK_POJO).memberName("IncrementalRefresh")
            .getter(getter(RefreshConfiguration::incrementalRefresh)).setter(setter(Builder::incrementalRefresh))
            .constructor(IncrementalRefresh::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncrementalRefresh").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCREMENTAL_REFRESH_FIELD));

    private static final long serialVersionUID = 1L;

    private final IncrementalRefresh incrementalRefresh;

    private RefreshConfiguration(BuilderImpl builder) {
        this.incrementalRefresh = builder.incrementalRefresh;
    }

    /**
     * <p>
     * The incremental refresh for the dataset.
     * </p>
     * 
     * @return The incremental refresh for the dataset.
     */
    public final IncrementalRefresh incrementalRefresh() {
        return incrementalRefresh;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(incrementalRefresh());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshConfiguration)) {
            return false;
        }
        RefreshConfiguration other = (RefreshConfiguration) obj;
        return Objects.equals(incrementalRefresh(), other.incrementalRefresh());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RefreshConfiguration").add("IncrementalRefresh", incrementalRefresh()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IncrementalRefresh":
            return Optional.ofNullable(clazz.cast(incrementalRefresh()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RefreshConfiguration, T> g) {
        return obj -> g.apply((RefreshConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RefreshConfiguration> {
        /**
         * <p>
         * The incremental refresh for the dataset.
         * </p>
         * 
         * @param incrementalRefresh
         *        The incremental refresh for the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incrementalRefresh(IncrementalRefresh incrementalRefresh);

        /**
         * <p>
         * The incremental refresh for the dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link IncrementalRefresh.Builder} avoiding the
         * need to create one manually via {@link IncrementalRefresh#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IncrementalRefresh.Builder#build()} is called immediately and its
         * result is passed to {@link #incrementalRefresh(IncrementalRefresh)}.
         * 
         * @param incrementalRefresh
         *        a consumer that will call methods on {@link IncrementalRefresh.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incrementalRefresh(IncrementalRefresh)
         */
        default Builder incrementalRefresh(Consumer<IncrementalRefresh.Builder> incrementalRefresh) {
            return incrementalRefresh(IncrementalRefresh.builder().applyMutation(incrementalRefresh).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IncrementalRefresh incrementalRefresh;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshConfiguration model) {
            incrementalRefresh(model.incrementalRefresh);
        }

        public final IncrementalRefresh.Builder getIncrementalRefresh() {
            return incrementalRefresh != null ? incrementalRefresh.toBuilder() : null;
        }

        public final void setIncrementalRefresh(IncrementalRefresh.BuilderImpl incrementalRefresh) {
            this.incrementalRefresh = incrementalRefresh != null ? incrementalRefresh.build() : null;
        }

        @Override
        public final Builder incrementalRefresh(IncrementalRefresh incrementalRefresh) {
            this.incrementalRefresh = incrementalRefresh;
            return this;
        }

        @Override
        public RefreshConfiguration build() {
            return new RefreshConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
