/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the percentage display format configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PercentageDisplayFormatConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PercentageDisplayFormatConfiguration.Builder, PercentageDisplayFormatConfiguration> {
    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prefix")
            .getter(getter(PercentageDisplayFormatConfiguration::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()).build();

    private static final SdkField<String> SUFFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Suffix")
            .getter(getter(PercentageDisplayFormatConfiguration::suffix)).setter(setter(Builder::suffix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Suffix").build()).build();

    private static final SdkField<NumericSeparatorConfiguration> SEPARATOR_CONFIGURATION_FIELD = SdkField
            .<NumericSeparatorConfiguration> builder(MarshallingType.SDK_POJO).memberName("SeparatorConfiguration")
            .getter(getter(PercentageDisplayFormatConfiguration::separatorConfiguration))
            .setter(setter(Builder::separatorConfiguration)).constructor(NumericSeparatorConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeparatorConfiguration").build())
            .build();

    private static final SdkField<DecimalPlacesConfiguration> DECIMAL_PLACES_CONFIGURATION_FIELD = SdkField
            .<DecimalPlacesConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DecimalPlacesConfiguration")
            .getter(getter(PercentageDisplayFormatConfiguration::decimalPlacesConfiguration))
            .setter(setter(Builder::decimalPlacesConfiguration))
            .constructor(DecimalPlacesConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalPlacesConfiguration").build())
            .build();

    private static final SdkField<NegativeValueConfiguration> NEGATIVE_VALUE_CONFIGURATION_FIELD = SdkField
            .<NegativeValueConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("NegativeValueConfiguration")
            .getter(getter(PercentageDisplayFormatConfiguration::negativeValueConfiguration))
            .setter(setter(Builder::negativeValueConfiguration))
            .constructor(NegativeValueConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NegativeValueConfiguration").build())
            .build();

    private static final SdkField<NullValueFormatConfiguration> NULL_VALUE_FORMAT_CONFIGURATION_FIELD = SdkField
            .<NullValueFormatConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("NullValueFormatConfiguration")
            .getter(getter(PercentageDisplayFormatConfiguration::nullValueFormatConfiguration))
            .setter(setter(Builder::nullValueFormatConfiguration))
            .constructor(NullValueFormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullValueFormatConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_FIELD, SUFFIX_FIELD,
            SEPARATOR_CONFIGURATION_FIELD, DECIMAL_PLACES_CONFIGURATION_FIELD, NEGATIVE_VALUE_CONFIGURATION_FIELD,
            NULL_VALUE_FORMAT_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String prefix;

    private final String suffix;

    private final NumericSeparatorConfiguration separatorConfiguration;

    private final DecimalPlacesConfiguration decimalPlacesConfiguration;

    private final NegativeValueConfiguration negativeValueConfiguration;

    private final NullValueFormatConfiguration nullValueFormatConfiguration;

    private PercentageDisplayFormatConfiguration(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.suffix = builder.suffix;
        this.separatorConfiguration = builder.separatorConfiguration;
        this.decimalPlacesConfiguration = builder.decimalPlacesConfiguration;
        this.negativeValueConfiguration = builder.negativeValueConfiguration;
        this.nullValueFormatConfiguration = builder.nullValueFormatConfiguration;
    }

    /**
     * <p>
     * Determines the prefix value of the percentage format.
     * </p>
     * 
     * @return Determines the prefix value of the percentage format.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * Determines the suffix value of the percentage format.
     * </p>
     * 
     * @return Determines the suffix value of the percentage format.
     */
    public final String suffix() {
        return suffix;
    }

    /**
     * <p>
     * The options that determine the numeric separator configuration.
     * </p>
     * 
     * @return The options that determine the numeric separator configuration.
     */
    public final NumericSeparatorConfiguration separatorConfiguration() {
        return separatorConfiguration;
    }

    /**
     * <p>
     * The option that determines the decimal places configuration.
     * </p>
     * 
     * @return The option that determines the decimal places configuration.
     */
    public final DecimalPlacesConfiguration decimalPlacesConfiguration() {
        return decimalPlacesConfiguration;
    }

    /**
     * <p>
     * The options that determine the negative value configuration.
     * </p>
     * 
     * @return The options that determine the negative value configuration.
     */
    public final NegativeValueConfiguration negativeValueConfiguration() {
        return negativeValueConfiguration;
    }

    /**
     * <p>
     * The options that determine the null value format configuration.
     * </p>
     * 
     * @return The options that determine the null value format configuration.
     */
    public final NullValueFormatConfiguration nullValueFormatConfiguration() {
        return nullValueFormatConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(suffix());
        hashCode = 31 * hashCode + Objects.hashCode(separatorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(decimalPlacesConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(negativeValueConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(nullValueFormatConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PercentageDisplayFormatConfiguration)) {
            return false;
        }
        PercentageDisplayFormatConfiguration other = (PercentageDisplayFormatConfiguration) obj;
        return Objects.equals(prefix(), other.prefix()) && Objects.equals(suffix(), other.suffix())
                && Objects.equals(separatorConfiguration(), other.separatorConfiguration())
                && Objects.equals(decimalPlacesConfiguration(), other.decimalPlacesConfiguration())
                && Objects.equals(negativeValueConfiguration(), other.negativeValueConfiguration())
                && Objects.equals(nullValueFormatConfiguration(), other.nullValueFormatConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PercentageDisplayFormatConfiguration")
                .add("Prefix", prefix() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Suffix", suffix() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SeparatorConfiguration", separatorConfiguration())
                .add("DecimalPlacesConfiguration", decimalPlacesConfiguration())
                .add("NegativeValueConfiguration", negativeValueConfiguration())
                .add("NullValueFormatConfiguration", nullValueFormatConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "Suffix":
            return Optional.ofNullable(clazz.cast(suffix()));
        case "SeparatorConfiguration":
            return Optional.ofNullable(clazz.cast(separatorConfiguration()));
        case "DecimalPlacesConfiguration":
            return Optional.ofNullable(clazz.cast(decimalPlacesConfiguration()));
        case "NegativeValueConfiguration":
            return Optional.ofNullable(clazz.cast(negativeValueConfiguration()));
        case "NullValueFormatConfiguration":
            return Optional.ofNullable(clazz.cast(nullValueFormatConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PercentageDisplayFormatConfiguration, T> g) {
        return obj -> g.apply((PercentageDisplayFormatConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PercentageDisplayFormatConfiguration> {
        /**
         * <p>
         * Determines the prefix value of the percentage format.
         * </p>
         * 
         * @param prefix
         *        Determines the prefix value of the percentage format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * Determines the suffix value of the percentage format.
         * </p>
         * 
         * @param suffix
         *        Determines the suffix value of the percentage format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suffix(String suffix);

        /**
         * <p>
         * The options that determine the numeric separator configuration.
         * </p>
         * 
         * @param separatorConfiguration
         *        The options that determine the numeric separator configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder separatorConfiguration(NumericSeparatorConfiguration separatorConfiguration);

        /**
         * <p>
         * The options that determine the numeric separator configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumericSeparatorConfiguration.Builder}
         * avoiding the need to create one manually via {@link NumericSeparatorConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumericSeparatorConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #separatorConfiguration(NumericSeparatorConfiguration)}.
         * 
         * @param separatorConfiguration
         *        a consumer that will call methods on {@link NumericSeparatorConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #separatorConfiguration(NumericSeparatorConfiguration)
         */
        default Builder separatorConfiguration(Consumer<NumericSeparatorConfiguration.Builder> separatorConfiguration) {
            return separatorConfiguration(NumericSeparatorConfiguration.builder().applyMutation(separatorConfiguration).build());
        }

        /**
         * <p>
         * The option that determines the decimal places configuration.
         * </p>
         * 
         * @param decimalPlacesConfiguration
         *        The option that determines the decimal places configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimalPlacesConfiguration(DecimalPlacesConfiguration decimalPlacesConfiguration);

        /**
         * <p>
         * The option that determines the decimal places configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link DecimalPlacesConfiguration.Builder}
         * avoiding the need to create one manually via {@link DecimalPlacesConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DecimalPlacesConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #decimalPlacesConfiguration(DecimalPlacesConfiguration)}.
         * 
         * @param decimalPlacesConfiguration
         *        a consumer that will call methods on {@link DecimalPlacesConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decimalPlacesConfiguration(DecimalPlacesConfiguration)
         */
        default Builder decimalPlacesConfiguration(Consumer<DecimalPlacesConfiguration.Builder> decimalPlacesConfiguration) {
            return decimalPlacesConfiguration(DecimalPlacesConfiguration.builder().applyMutation(decimalPlacesConfiguration)
                    .build());
        }

        /**
         * <p>
         * The options that determine the negative value configuration.
         * </p>
         * 
         * @param negativeValueConfiguration
         *        The options that determine the negative value configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder negativeValueConfiguration(NegativeValueConfiguration negativeValueConfiguration);

        /**
         * <p>
         * The options that determine the negative value configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link NegativeValueConfiguration.Builder}
         * avoiding the need to create one manually via {@link NegativeValueConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NegativeValueConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #negativeValueConfiguration(NegativeValueConfiguration)}.
         * 
         * @param negativeValueConfiguration
         *        a consumer that will call methods on {@link NegativeValueConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #negativeValueConfiguration(NegativeValueConfiguration)
         */
        default Builder negativeValueConfiguration(Consumer<NegativeValueConfiguration.Builder> negativeValueConfiguration) {
            return negativeValueConfiguration(NegativeValueConfiguration.builder().applyMutation(negativeValueConfiguration)
                    .build());
        }

        /**
         * <p>
         * The options that determine the null value format configuration.
         * </p>
         * 
         * @param nullValueFormatConfiguration
         *        The options that determine the null value format configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nullValueFormatConfiguration(NullValueFormatConfiguration nullValueFormatConfiguration);

        /**
         * <p>
         * The options that determine the null value format configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link NullValueFormatConfiguration.Builder}
         * avoiding the need to create one manually via {@link NullValueFormatConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NullValueFormatConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #nullValueFormatConfiguration(NullValueFormatConfiguration)}.
         * 
         * @param nullValueFormatConfiguration
         *        a consumer that will call methods on {@link NullValueFormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nullValueFormatConfiguration(NullValueFormatConfiguration)
         */
        default Builder nullValueFormatConfiguration(Consumer<NullValueFormatConfiguration.Builder> nullValueFormatConfiguration) {
            return nullValueFormatConfiguration(NullValueFormatConfiguration.builder()
                    .applyMutation(nullValueFormatConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String prefix;

        private String suffix;

        private NumericSeparatorConfiguration separatorConfiguration;

        private DecimalPlacesConfiguration decimalPlacesConfiguration;

        private NegativeValueConfiguration negativeValueConfiguration;

        private NullValueFormatConfiguration nullValueFormatConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PercentageDisplayFormatConfiguration model) {
            prefix(model.prefix);
            suffix(model.suffix);
            separatorConfiguration(model.separatorConfiguration);
            decimalPlacesConfiguration(model.decimalPlacesConfiguration);
            negativeValueConfiguration(model.negativeValueConfiguration);
            nullValueFormatConfiguration(model.nullValueFormatConfiguration);
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getSuffix() {
            return suffix;
        }

        public final void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public final Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public final NumericSeparatorConfiguration.Builder getSeparatorConfiguration() {
            return separatorConfiguration != null ? separatorConfiguration.toBuilder() : null;
        }

        public final void setSeparatorConfiguration(NumericSeparatorConfiguration.BuilderImpl separatorConfiguration) {
            this.separatorConfiguration = separatorConfiguration != null ? separatorConfiguration.build() : null;
        }

        @Override
        public final Builder separatorConfiguration(NumericSeparatorConfiguration separatorConfiguration) {
            this.separatorConfiguration = separatorConfiguration;
            return this;
        }

        public final DecimalPlacesConfiguration.Builder getDecimalPlacesConfiguration() {
            return decimalPlacesConfiguration != null ? decimalPlacesConfiguration.toBuilder() : null;
        }

        public final void setDecimalPlacesConfiguration(DecimalPlacesConfiguration.BuilderImpl decimalPlacesConfiguration) {
            this.decimalPlacesConfiguration = decimalPlacesConfiguration != null ? decimalPlacesConfiguration.build() : null;
        }

        @Override
        public final Builder decimalPlacesConfiguration(DecimalPlacesConfiguration decimalPlacesConfiguration) {
            this.decimalPlacesConfiguration = decimalPlacesConfiguration;
            return this;
        }

        public final NegativeValueConfiguration.Builder getNegativeValueConfiguration() {
            return negativeValueConfiguration != null ? negativeValueConfiguration.toBuilder() : null;
        }

        public final void setNegativeValueConfiguration(NegativeValueConfiguration.BuilderImpl negativeValueConfiguration) {
            this.negativeValueConfiguration = negativeValueConfiguration != null ? negativeValueConfiguration.build() : null;
        }

        @Override
        public final Builder negativeValueConfiguration(NegativeValueConfiguration negativeValueConfiguration) {
            this.negativeValueConfiguration = negativeValueConfiguration;
            return this;
        }

        public final NullValueFormatConfiguration.Builder getNullValueFormatConfiguration() {
            return nullValueFormatConfiguration != null ? nullValueFormatConfiguration.toBuilder() : null;
        }

        public final void setNullValueFormatConfiguration(NullValueFormatConfiguration.BuilderImpl nullValueFormatConfiguration) {
            this.nullValueFormatConfiguration = nullValueFormatConfiguration != null ? nullValueFormatConfiguration.build()
                    : null;
        }

        @Override
        public final Builder nullValueFormatConfiguration(NullValueFormatConfiguration nullValueFormatConfiguration) {
            this.nullValueFormatConfiguration = nullValueFormatConfiguration;
            return this;
        }

        @Override
        public PercentageDisplayFormatConfiguration build() {
            return new PercentageDisplayFormatConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
