/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of selectable values that are used in a control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterSelectableValues implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterSelectableValues.Builder, ParameterSelectableValues> {
    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(ParameterSelectableValues::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ColumnIdentifier> LINK_TO_DATA_SET_COLUMN_FIELD = SdkField
            .<ColumnIdentifier> builder(MarshallingType.SDK_POJO).memberName("LinkToDataSetColumn")
            .getter(getter(ParameterSelectableValues::linkToDataSetColumn)).setter(setter(Builder::linkToDataSetColumn))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkToDataSetColumn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUES_FIELD,
            LINK_TO_DATA_SET_COLUMN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> values;

    private final ColumnIdentifier linkToDataSetColumn;

    private ParameterSelectableValues(BuilderImpl builder) {
        this.values = builder.values;
        this.linkToDataSetColumn = builder.linkToDataSetColumn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values that are used in <code>ParameterSelectableValues</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The values that are used in <code>ParameterSelectableValues</code>.
     */
    public final List<String> values() {
        return values;
    }

    /**
     * <p>
     * The column identifier that fetches values from the data set.
     * </p>
     * 
     * @return The column identifier that fetches values from the data set.
     */
    public final ColumnIdentifier linkToDataSetColumn() {
        return linkToDataSetColumn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(linkToDataSetColumn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterSelectableValues)) {
            return false;
        }
        ParameterSelectableValues other = (ParameterSelectableValues) obj;
        return hasValues() == other.hasValues() && Objects.equals(values(), other.values())
                && Objects.equals(linkToDataSetColumn(), other.linkToDataSetColumn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterSelectableValues").add("Values", hasValues() ? values() : null)
                .add("LinkToDataSetColumn", linkToDataSetColumn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "LinkToDataSetColumn":
            return Optional.ofNullable(clazz.cast(linkToDataSetColumn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterSelectableValues, T> g) {
        return obj -> g.apply((ParameterSelectableValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterSelectableValues> {
        /**
         * <p>
         * The values that are used in <code>ParameterSelectableValues</code>.
         * </p>
         * 
         * @param values
         *        The values that are used in <code>ParameterSelectableValues</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The values that are used in <code>ParameterSelectableValues</code>.
         * </p>
         * 
         * @param values
         *        The values that are used in <code>ParameterSelectableValues</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * The column identifier that fetches values from the data set.
         * </p>
         * 
         * @param linkToDataSetColumn
         *        The column identifier that fetches values from the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkToDataSetColumn(ColumnIdentifier linkToDataSetColumn);

        /**
         * <p>
         * The column identifier that fetches values from the data set.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #linkToDataSetColumn(ColumnIdentifier)}.
         * 
         * @param linkToDataSetColumn
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linkToDataSetColumn(ColumnIdentifier)
         */
        default Builder linkToDataSetColumn(Consumer<ColumnIdentifier.Builder> linkToDataSetColumn) {
            return linkToDataSetColumn(ColumnIdentifier.builder().applyMutation(linkToDataSetColumn).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private ColumnIdentifier linkToDataSetColumn;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterSelectableValues model) {
            values(model.values);
            linkToDataSetColumn(model.linkToDataSetColumn);
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<String> values) {
            this.values = ParameterSelectableValueListCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ParameterSelectableValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final ColumnIdentifier.Builder getLinkToDataSetColumn() {
            return linkToDataSetColumn != null ? linkToDataSetColumn.toBuilder() : null;
        }

        public final void setLinkToDataSetColumn(ColumnIdentifier.BuilderImpl linkToDataSetColumn) {
            this.linkToDataSetColumn = linkToDataSetColumn != null ? linkToDataSetColumn.build() : null;
        }

        @Override
        public final Builder linkToDataSetColumn(ColumnIdentifier linkToDataSetColumn) {
            this.linkToDataSetColumn = linkToDataSetColumn;
            return this;
        }

        @Override
        public ParameterSelectableValues build() {
            return new ParameterSelectableValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
