/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnalysesResponse extends QuickSightResponse implements
        ToCopyableBuilder<ListAnalysesResponse.Builder, ListAnalysesResponse> {
    private static final SdkField<List<AnalysisSummary>> ANALYSIS_SUMMARY_LIST_FIELD = SdkField
            .<List<AnalysisSummary>> builder(MarshallingType.LIST)
            .memberName("AnalysisSummaryList")
            .getter(getter(ListAnalysesResponse::analysisSummaryList))
            .setter(setter(Builder::analysisSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalysisSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalysisSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAnalysesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(ListAnalysesResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(ListAnalysesResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_SUMMARY_LIST_FIELD,
            NEXT_TOKEN_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));

    private final List<AnalysisSummary> analysisSummaryList;

    private final String nextToken;

    private final Integer status;

    private final String requestId;

    private ListAnalysesResponse(BuilderImpl builder) {
        super(builder);
        this.analysisSummaryList = builder.analysisSummaryList;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnalysisSummaryList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnalysisSummaryList() {
        return analysisSummaryList != null && !(analysisSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata describing each of the analyses that are listed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalysisSummaryList} method.
     * </p>
     * 
     * @return Metadata describing each of the analyses that are listed.
     */
    public final List<AnalysisSummary> analysisSummaryList() {
        return analysisSummaryList;
    }

    /**
     * <p>
     * A pagination token that can be used in a subsequent request.
     * </p>
     * 
     * @return A pagination token that can be used in a subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalysisSummaryList() ? analysisSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnalysesResponse)) {
            return false;
        }
        ListAnalysesResponse other = (ListAnalysesResponse) obj;
        return hasAnalysisSummaryList() == other.hasAnalysisSummaryList()
                && Objects.equals(analysisSummaryList(), other.analysisSummaryList())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(status(), other.status())
                && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnalysesResponse")
                .add("AnalysisSummaryList", hasAnalysisSummaryList() ? analysisSummaryList() : null)
                .add("NextToken", nextToken()).add("Status", status()).add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnalysisSummaryList":
            return Optional.ofNullable(clazz.cast(analysisSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnalysesResponse, T> g) {
        return obj -> g.apply((ListAnalysesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAnalysesResponse> {
        /**
         * <p>
         * Metadata describing each of the analyses that are listed.
         * </p>
         * 
         * @param analysisSummaryList
         *        Metadata describing each of the analyses that are listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisSummaryList(Collection<AnalysisSummary> analysisSummaryList);

        /**
         * <p>
         * Metadata describing each of the analyses that are listed.
         * </p>
         * 
         * @param analysisSummaryList
         *        Metadata describing each of the analyses that are listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisSummaryList(AnalysisSummary... analysisSummaryList);

        /**
         * <p>
         * Metadata describing each of the analyses that are listed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AnalysisSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.AnalysisSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AnalysisSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #analysisSummaryList(List<AnalysisSummary>)}.
         * 
         * @param analysisSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AnalysisSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisSummaryList(java.util.Collection<AnalysisSummary>)
         */
        Builder analysisSummaryList(Consumer<AnalysisSummary.Builder>... analysisSummaryList);

        /**
         * <p>
         * A pagination token that can be used in a subsequent request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that can be used in a subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private List<AnalysisSummary> analysisSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnalysesResponse model) {
            super(model);
            analysisSummaryList(model.analysisSummaryList);
            nextToken(model.nextToken);
            status(model.status);
            requestId(model.requestId);
        }

        public final List<AnalysisSummary.Builder> getAnalysisSummaryList() {
            List<AnalysisSummary.Builder> result = AnalysisSummaryListCopier.copyToBuilder(this.analysisSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysisSummaryList(Collection<AnalysisSummary.BuilderImpl> analysisSummaryList) {
            this.analysisSummaryList = AnalysisSummaryListCopier.copyFromBuilder(analysisSummaryList);
        }

        @Override
        public final Builder analysisSummaryList(Collection<AnalysisSummary> analysisSummaryList) {
            this.analysisSummaryList = AnalysisSummaryListCopier.copy(analysisSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisSummaryList(AnalysisSummary... analysisSummaryList) {
            analysisSummaryList(Arrays.asList(analysisSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisSummaryList(Consumer<AnalysisSummary.Builder>... analysisSummaryList) {
            analysisSummaryList(Stream.of(analysisSummaryList).map(c -> AnalysisSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public ListAnalysesResponse build() {
            return new ListAnalysesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
