/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The series axis configuration of a line chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineSeriesAxisDisplayOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<LineSeriesAxisDisplayOptions.Builder, LineSeriesAxisDisplayOptions> {
    private static final SdkField<AxisDisplayOptions> AXIS_OPTIONS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("AxisOptions")
            .getter(getter(LineSeriesAxisDisplayOptions::axisOptions)).setter(setter(Builder::axisOptions))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisOptions").build()).build();

    private static final SdkField<List<MissingDataConfiguration>> MISSING_DATA_CONFIGURATIONS_FIELD = SdkField
            .<List<MissingDataConfiguration>> builder(MarshallingType.LIST)
            .memberName("MissingDataConfigurations")
            .getter(getter(LineSeriesAxisDisplayOptions::missingDataConfigurations))
            .setter(setter(Builder::missingDataConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingDataConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MissingDataConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(MissingDataConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AXIS_OPTIONS_FIELD,
            MISSING_DATA_CONFIGURATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AxisDisplayOptions axisOptions;

    private final List<MissingDataConfiguration> missingDataConfigurations;

    private LineSeriesAxisDisplayOptions(BuilderImpl builder) {
        this.axisOptions = builder.axisOptions;
        this.missingDataConfigurations = builder.missingDataConfigurations;
    }

    /**
     * <p>
     * The options that determine the presentation of the line series axis.
     * </p>
     * 
     * @return The options that determine the presentation of the line series axis.
     */
    public final AxisDisplayOptions axisOptions() {
        return axisOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the MissingDataConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMissingDataConfigurations() {
        return missingDataConfigurations != null && !(missingDataConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration options that determine how missing data is treated during the rendering of a line chart.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMissingDataConfigurations} method.
     * </p>
     * 
     * @return The configuration options that determine how missing data is treated during the rendering of a line
     *         chart.
     */
    public final List<MissingDataConfiguration> missingDataConfigurations() {
        return missingDataConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(axisOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasMissingDataConfigurations() ? missingDataConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineSeriesAxisDisplayOptions)) {
            return false;
        }
        LineSeriesAxisDisplayOptions other = (LineSeriesAxisDisplayOptions) obj;
        return Objects.equals(axisOptions(), other.axisOptions())
                && hasMissingDataConfigurations() == other.hasMissingDataConfigurations()
                && Objects.equals(missingDataConfigurations(), other.missingDataConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineSeriesAxisDisplayOptions").add("AxisOptions", axisOptions())
                .add("MissingDataConfigurations", hasMissingDataConfigurations() ? missingDataConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AxisOptions":
            return Optional.ofNullable(clazz.cast(axisOptions()));
        case "MissingDataConfigurations":
            return Optional.ofNullable(clazz.cast(missingDataConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LineSeriesAxisDisplayOptions, T> g) {
        return obj -> g.apply((LineSeriesAxisDisplayOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineSeriesAxisDisplayOptions> {
        /**
         * <p>
         * The options that determine the presentation of the line series axis.
         * </p>
         * 
         * @param axisOptions
         *        The options that determine the presentation of the line series axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder axisOptions(AxisDisplayOptions axisOptions);

        /**
         * <p>
         * The options that determine the presentation of the line series axis.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #axisOptions(AxisDisplayOptions)}.
         * 
         * @param axisOptions
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #axisOptions(AxisDisplayOptions)
         */
        default Builder axisOptions(Consumer<AxisDisplayOptions.Builder> axisOptions) {
            return axisOptions(AxisDisplayOptions.builder().applyMutation(axisOptions).build());
        }

        /**
         * <p>
         * The configuration options that determine how missing data is treated during the rendering of a line chart.
         * </p>
         * 
         * @param missingDataConfigurations
         *        The configuration options that determine how missing data is treated during the rendering of a line
         *        chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingDataConfigurations(Collection<MissingDataConfiguration> missingDataConfigurations);

        /**
         * <p>
         * The configuration options that determine how missing data is treated during the rendering of a line chart.
         * </p>
         * 
         * @param missingDataConfigurations
         *        The configuration options that determine how missing data is treated during the rendering of a line
         *        chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingDataConfigurations(MissingDataConfiguration... missingDataConfigurations);

        /**
         * <p>
         * The configuration options that determine how missing data is treated during the rendering of a line chart.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MissingDataConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.MissingDataConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MissingDataConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #missingDataConfigurations(List<MissingDataConfiguration>)}.
         * 
         * @param missingDataConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MissingDataConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #missingDataConfigurations(java.util.Collection<MissingDataConfiguration>)
         */
        Builder missingDataConfigurations(Consumer<MissingDataConfiguration.Builder>... missingDataConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private AxisDisplayOptions axisOptions;

        private List<MissingDataConfiguration> missingDataConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LineSeriesAxisDisplayOptions model) {
            axisOptions(model.axisOptions);
            missingDataConfigurations(model.missingDataConfigurations);
        }

        public final AxisDisplayOptions.Builder getAxisOptions() {
            return axisOptions != null ? axisOptions.toBuilder() : null;
        }

        public final void setAxisOptions(AxisDisplayOptions.BuilderImpl axisOptions) {
            this.axisOptions = axisOptions != null ? axisOptions.build() : null;
        }

        @Override
        public final Builder axisOptions(AxisDisplayOptions axisOptions) {
            this.axisOptions = axisOptions;
            return this;
        }

        public final List<MissingDataConfiguration.Builder> getMissingDataConfigurations() {
            List<MissingDataConfiguration.Builder> result = MissingDataConfigurationListCopier
                    .copyToBuilder(this.missingDataConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMissingDataConfigurations(Collection<MissingDataConfiguration.BuilderImpl> missingDataConfigurations) {
            this.missingDataConfigurations = MissingDataConfigurationListCopier.copyFromBuilder(missingDataConfigurations);
        }

        @Override
        public final Builder missingDataConfigurations(Collection<MissingDataConfiguration> missingDataConfigurations) {
            this.missingDataConfigurations = MissingDataConfigurationListCopier.copy(missingDataConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missingDataConfigurations(MissingDataConfiguration... missingDataConfigurations) {
            missingDataConfigurations(Arrays.asList(missingDataConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missingDataConfigurations(Consumer<MissingDataConfiguration.Builder>... missingDataConfigurations) {
            missingDataConfigurations(Stream.of(missingDataConfigurations)
                    .map(c -> MissingDataConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public LineSeriesAxisDisplayOptions build() {
            return new LineSeriesAxisDisplayOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
