/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>GroupSearchFilter</code> object that you want to apply to your search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupSearchFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<GroupSearchFilter.Builder, GroupSearchFilter> {
    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(GroupSearchFilter::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GroupSearchFilter::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(GroupSearchFilter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATOR_FIELD, NAME_FIELD,
            VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String operator;

    private final String name;

    private final String value;

    private GroupSearchFilter(BuilderImpl builder) {
        this.operator = builder.operator;
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The comparison operator that you want to use as a filter, for example <code>"Operator": "StartsWith"</code>.
     * Currently, the only supported operator is <code>StartsWith</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link GroupFilterOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatorAsString}.
     * </p>
     * 
     * @return The comparison operator that you want to use as a filter, for example
     *         <code>"Operator": "StartsWith"</code>. Currently, the only supported operator is <code>StartsWith</code>.
     * @see GroupFilterOperator
     */
    public final GroupFilterOperator operator() {
        return GroupFilterOperator.fromValue(operator);
    }

    /**
     * <p>
     * The comparison operator that you want to use as a filter, for example <code>"Operator": "StartsWith"</code>.
     * Currently, the only supported operator is <code>StartsWith</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link GroupFilterOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatorAsString}.
     * </p>
     * 
     * @return The comparison operator that you want to use as a filter, for example
     *         <code>"Operator": "StartsWith"</code>. Currently, the only supported operator is <code>StartsWith</code>.
     * @see GroupFilterOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    /**
     * <p>
     * The name of the value that you want to use as a filter, for example <code>"Name": "GROUP_NAME"</code>. Currently,
     * the only supported name is <code>GROUP_NAME</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link GroupFilterAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the value that you want to use as a filter, for example <code>"Name": "GROUP_NAME"</code>.
     *         Currently, the only supported name is <code>GROUP_NAME</code>.
     * @see GroupFilterAttribute
     */
    public final GroupFilterAttribute name() {
        return GroupFilterAttribute.fromValue(name);
    }

    /**
     * <p>
     * The name of the value that you want to use as a filter, for example <code>"Name": "GROUP_NAME"</code>. Currently,
     * the only supported name is <code>GROUP_NAME</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link GroupFilterAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the value that you want to use as a filter, for example <code>"Name": "GROUP_NAME"</code>.
     *         Currently, the only supported name is <code>GROUP_NAME</code>.
     * @see GroupFilterAttribute
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The value of the named item, in this case <code>GROUP_NAME</code>, that you want to use as a filter.
     * </p>
     * 
     * @return The value of the named item, in this case <code>GROUP_NAME</code>, that you want to use as a filter.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupSearchFilter)) {
            return false;
        }
        GroupSearchFilter other = (GroupSearchFilter) obj;
        return Objects.equals(operatorAsString(), other.operatorAsString())
                && Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupSearchFilter").add("Operator", operatorAsString()).add("Name", nameAsString())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupSearchFilter, T> g) {
        return obj -> g.apply((GroupSearchFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupSearchFilter> {
        /**
         * <p>
         * The comparison operator that you want to use as a filter, for example <code>"Operator": "StartsWith"</code>.
         * Currently, the only supported operator is <code>StartsWith</code>.
         * </p>
         * 
         * @param operator
         *        The comparison operator that you want to use as a filter, for example
         *        <code>"Operator": "StartsWith"</code>. Currently, the only supported operator is
         *        <code>StartsWith</code>.
         * @see GroupFilterOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupFilterOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The comparison operator that you want to use as a filter, for example <code>"Operator": "StartsWith"</code>.
         * Currently, the only supported operator is <code>StartsWith</code>.
         * </p>
         * 
         * @param operator
         *        The comparison operator that you want to use as a filter, for example
         *        <code>"Operator": "StartsWith"</code>. Currently, the only supported operator is
         *        <code>StartsWith</code>.
         * @see GroupFilterOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupFilterOperator
         */
        Builder operator(GroupFilterOperator operator);

        /**
         * <p>
         * The name of the value that you want to use as a filter, for example <code>"Name": "GROUP_NAME"</code>.
         * Currently, the only supported name is <code>GROUP_NAME</code>.
         * </p>
         * 
         * @param name
         *        The name of the value that you want to use as a filter, for example <code>"Name": "GROUP_NAME"</code>.
         *        Currently, the only supported name is <code>GROUP_NAME</code>.
         * @see GroupFilterAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupFilterAttribute
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the value that you want to use as a filter, for example <code>"Name": "GROUP_NAME"</code>.
         * Currently, the only supported name is <code>GROUP_NAME</code>.
         * </p>
         * 
         * @param name
         *        The name of the value that you want to use as a filter, for example <code>"Name": "GROUP_NAME"</code>.
         *        Currently, the only supported name is <code>GROUP_NAME</code>.
         * @see GroupFilterAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupFilterAttribute
         */
        Builder name(GroupFilterAttribute name);

        /**
         * <p>
         * The value of the named item, in this case <code>GROUP_NAME</code>, that you want to use as a filter.
         * </p>
         * 
         * @param value
         *        The value of the named item, in this case <code>GROUP_NAME</code>, that you want to use as a filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String operator;

        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupSearchFilter model) {
            operator(model.operator);
            name(model.name);
            value(model.value);
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(GroupFilterOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(GroupFilterAttribute name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public GroupSearchFilter build() {
            return new GroupSearchFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
