/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field series item configuration of a line chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldSeriesItem implements SdkPojo, Serializable, ToCopyableBuilder<FieldSeriesItem.Builder, FieldSeriesItem> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldId").getter(getter(FieldSeriesItem::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()).build();

    private static final SdkField<String> AXIS_BINDING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AxisBinding").getter(getter(FieldSeriesItem::axisBindingAsString)).setter(setter(Builder::axisBinding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisBinding").build()).build();

    private static final SdkField<LineChartSeriesSettings> SETTINGS_FIELD = SdkField
            .<LineChartSeriesSettings> builder(MarshallingType.SDK_POJO).memberName("Settings")
            .getter(getter(FieldSeriesItem::settings)).setter(setter(Builder::settings))
            .constructor(LineChartSeriesSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD,
            AXIS_BINDING_FIELD, SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fieldId;

    private final String axisBinding;

    private final LineChartSeriesSettings settings;

    private FieldSeriesItem(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.axisBinding = builder.axisBinding;
        this.settings = builder.settings;
    }

    /**
     * <p>
     * The field ID of the field for which you are setting the axis binding.
     * </p>
     * 
     * @return The field ID of the field for which you are setting the axis binding.
     */
    public final String fieldId() {
        return fieldId;
    }

    /**
     * <p>
     * The axis that you are binding the field to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #axisBinding} will
     * return {@link AxisBinding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #axisBindingAsString}.
     * </p>
     * 
     * @return The axis that you are binding the field to.
     * @see AxisBinding
     */
    public final AxisBinding axisBinding() {
        return AxisBinding.fromValue(axisBinding);
    }

    /**
     * <p>
     * The axis that you are binding the field to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #axisBinding} will
     * return {@link AxisBinding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #axisBindingAsString}.
     * </p>
     * 
     * @return The axis that you are binding the field to.
     * @see AxisBinding
     */
    public final String axisBindingAsString() {
        return axisBinding;
    }

    /**
     * <p>
     * The options that determine the presentation of line series associated to the field.
     * </p>
     * 
     * @return The options that determine the presentation of line series associated to the field.
     */
    public final LineChartSeriesSettings settings() {
        return settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(axisBindingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldSeriesItem)) {
            return false;
        }
        FieldSeriesItem other = (FieldSeriesItem) obj;
        return Objects.equals(fieldId(), other.fieldId()) && Objects.equals(axisBindingAsString(), other.axisBindingAsString())
                && Objects.equals(settings(), other.settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldSeriesItem").add("FieldId", fieldId()).add("AxisBinding", axisBindingAsString())
                .add("Settings", settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        case "AxisBinding":
            return Optional.ofNullable(clazz.cast(axisBindingAsString()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldSeriesItem, T> g) {
        return obj -> g.apply((FieldSeriesItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldSeriesItem> {
        /**
         * <p>
         * The field ID of the field for which you are setting the axis binding.
         * </p>
         * 
         * @param fieldId
         *        The field ID of the field for which you are setting the axis binding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);

        /**
         * <p>
         * The axis that you are binding the field to.
         * </p>
         * 
         * @param axisBinding
         *        The axis that you are binding the field to.
         * @see AxisBinding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AxisBinding
         */
        Builder axisBinding(String axisBinding);

        /**
         * <p>
         * The axis that you are binding the field to.
         * </p>
         * 
         * @param axisBinding
         *        The axis that you are binding the field to.
         * @see AxisBinding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AxisBinding
         */
        Builder axisBinding(AxisBinding axisBinding);

        /**
         * <p>
         * The options that determine the presentation of line series associated to the field.
         * </p>
         * 
         * @param settings
         *        The options that determine the presentation of line series associated to the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(LineChartSeriesSettings settings);

        /**
         * <p>
         * The options that determine the presentation of line series associated to the field.
         * </p>
         * This is a convenience method that creates an instance of the {@link LineChartSeriesSettings.Builder} avoiding
         * the need to create one manually via {@link LineChartSeriesSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LineChartSeriesSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #settings(LineChartSeriesSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link LineChartSeriesSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(LineChartSeriesSettings)
         */
        default Builder settings(Consumer<LineChartSeriesSettings.Builder> settings) {
            return settings(LineChartSeriesSettings.builder().applyMutation(settings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fieldId;

        private String axisBinding;

        private LineChartSeriesSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldSeriesItem model) {
            fieldId(model.fieldId);
            axisBinding(model.axisBinding);
            settings(model.settings);
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final String getAxisBinding() {
            return axisBinding;
        }

        public final void setAxisBinding(String axisBinding) {
            this.axisBinding = axisBinding;
        }

        @Override
        public final Builder axisBinding(String axisBinding) {
            this.axisBinding = axisBinding;
            return this;
        }

        @Override
        public final Builder axisBinding(AxisBinding axisBinding) {
            this.axisBinding(axisBinding == null ? null : axisBinding.toString());
            return this;
        }

        public final LineChartSeriesSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(LineChartSeriesSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(LineChartSeriesSettings settings) {
            this.settings = settings;
            return this;
        }

        @Override
        public FieldSeriesItem build() {
            return new FieldSeriesItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
