/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The default options that correspond to the filter control type of a <code>DateTimePicker</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultDateTimePickerControlOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultDateTimePickerControlOptions.Builder, DefaultDateTimePickerControlOptions> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DefaultDateTimePickerControlOptions::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<DateTimePickerControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField
            .<DateTimePickerControlDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("DisplayOptions")
            .getter(getter(DefaultDateTimePickerControlOptions::displayOptions)).setter(setter(Builder::displayOptions))
            .constructor(DateTimePickerControlDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            DISPLAY_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final DateTimePickerControlDisplayOptions displayOptions;

    private DefaultDateTimePickerControlOptions(BuilderImpl builder) {
        this.type = builder.type;
        this.displayOptions = builder.displayOptions;
    }

    /**
     * <p>
     * The date time picker type of the <code>DefaultDateTimePickerControlOptions</code>. Choose one of the following
     * options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE_VALUED</code>: The filter condition is a fixed date.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DATE_RANGE</code>: The filter condition is a date time range.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SheetControlDateTimePickerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The date time picker type of the <code>DefaultDateTimePickerControlOptions</code>. Choose one of the
     *         following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE_VALUED</code>: The filter condition is a fixed date.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DATE_RANGE</code>: The filter condition is a date time range.
     *         </p>
     *         </li>
     * @see SheetControlDateTimePickerType
     */
    public final SheetControlDateTimePickerType type() {
        return SheetControlDateTimePickerType.fromValue(type);
    }

    /**
     * <p>
     * The date time picker type of the <code>DefaultDateTimePickerControlOptions</code>. Choose one of the following
     * options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE_VALUED</code>: The filter condition is a fixed date.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DATE_RANGE</code>: The filter condition is a date time range.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SheetControlDateTimePickerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The date time picker type of the <code>DefaultDateTimePickerControlOptions</code>. Choose one of the
     *         following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE_VALUED</code>: The filter condition is a fixed date.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DATE_RANGE</code>: The filter condition is a date time range.
     *         </p>
     *         </li>
     * @see SheetControlDateTimePickerType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The display options of a control.
     * </p>
     * 
     * @return The display options of a control.
     */
    public final DateTimePickerControlDisplayOptions displayOptions() {
        return displayOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultDateTimePickerControlOptions)) {
            return false;
        }
        DefaultDateTimePickerControlOptions other = (DefaultDateTimePickerControlOptions) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(displayOptions(), other.displayOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultDateTimePickerControlOptions").add("Type", typeAsString())
                .add("DisplayOptions", displayOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "DisplayOptions":
            return Optional.ofNullable(clazz.cast(displayOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultDateTimePickerControlOptions, T> g) {
        return obj -> g.apply((DefaultDateTimePickerControlOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultDateTimePickerControlOptions> {
        /**
         * <p>
         * The date time picker type of the <code>DefaultDateTimePickerControlOptions</code>. Choose one of the
         * following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE_VALUED</code>: The filter condition is a fixed date.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DATE_RANGE</code>: The filter condition is a date time range.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The date time picker type of the <code>DefaultDateTimePickerControlOptions</code>. Choose one of the
         *        following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE_VALUED</code>: The filter condition is a fixed date.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DATE_RANGE</code>: The filter condition is a date time range.
         *        </p>
         *        </li>
         * @see SheetControlDateTimePickerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetControlDateTimePickerType
         */
        Builder type(String type);

        /**
         * <p>
         * The date time picker type of the <code>DefaultDateTimePickerControlOptions</code>. Choose one of the
         * following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE_VALUED</code>: The filter condition is a fixed date.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DATE_RANGE</code>: The filter condition is a date time range.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The date time picker type of the <code>DefaultDateTimePickerControlOptions</code>. Choose one of the
         *        following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE_VALUED</code>: The filter condition is a fixed date.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DATE_RANGE</code>: The filter condition is a date time range.
         *        </p>
         *        </li>
         * @see SheetControlDateTimePickerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetControlDateTimePickerType
         */
        Builder type(SheetControlDateTimePickerType type);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * 
         * @param displayOptions
         *        The display options of a control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayOptions(DateTimePickerControlDisplayOptions displayOptions);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DateTimePickerControlDisplayOptions.Builder} avoiding the need to create one manually via
         * {@link DateTimePickerControlDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateTimePickerControlDisplayOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #displayOptions(DateTimePickerControlDisplayOptions)}.
         * 
         * @param displayOptions
         *        a consumer that will call methods on {@link DateTimePickerControlDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayOptions(DateTimePickerControlDisplayOptions)
         */
        default Builder displayOptions(Consumer<DateTimePickerControlDisplayOptions.Builder> displayOptions) {
            return displayOptions(DateTimePickerControlDisplayOptions.builder().applyMutation(displayOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private DateTimePickerControlDisplayOptions displayOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultDateTimePickerControlOptions model) {
            type(model.type);
            displayOptions(model.displayOptions);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SheetControlDateTimePickerType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final DateTimePickerControlDisplayOptions.Builder getDisplayOptions() {
            return displayOptions != null ? displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(DateTimePickerControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(DateTimePickerControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        @Override
        public DefaultDateTimePickerControlOptions build() {
            return new DefaultDateTimePickerControlOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
