/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The refresh properties of a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetRefreshProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSetRefreshProperties.Builder, DataSetRefreshProperties> {
    private static final SdkField<RefreshConfiguration> REFRESH_CONFIGURATION_FIELD = SdkField
            .<RefreshConfiguration> builder(MarshallingType.SDK_POJO).memberName("RefreshConfiguration")
            .getter(getter(DataSetRefreshProperties::refreshConfiguration)).setter(setter(Builder::refreshConfiguration))
            .constructor(RefreshConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFRESH_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final RefreshConfiguration refreshConfiguration;

    private DataSetRefreshProperties(BuilderImpl builder) {
        this.refreshConfiguration = builder.refreshConfiguration;
    }

    /**
     * <p>
     * The refresh configuration for a dataset.
     * </p>
     * 
     * @return The refresh configuration for a dataset.
     */
    public final RefreshConfiguration refreshConfiguration() {
        return refreshConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(refreshConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetRefreshProperties)) {
            return false;
        }
        DataSetRefreshProperties other = (DataSetRefreshProperties) obj;
        return Objects.equals(refreshConfiguration(), other.refreshConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSetRefreshProperties").add("RefreshConfiguration", refreshConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RefreshConfiguration":
            return Optional.ofNullable(clazz.cast(refreshConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSetRefreshProperties, T> g) {
        return obj -> g.apply((DataSetRefreshProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetRefreshProperties> {
        /**
         * <p>
         * The refresh configuration for a dataset.
         * </p>
         * 
         * @param refreshConfiguration
         *        The refresh configuration for a dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshConfiguration(RefreshConfiguration refreshConfiguration);

        /**
         * <p>
         * The refresh configuration for a dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link RefreshConfiguration.Builder} avoiding
         * the need to create one manually via {@link RefreshConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RefreshConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #refreshConfiguration(RefreshConfiguration)}.
         * 
         * @param refreshConfiguration
         *        a consumer that will call methods on {@link RefreshConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshConfiguration(RefreshConfiguration)
         */
        default Builder refreshConfiguration(Consumer<RefreshConfiguration.Builder> refreshConfiguration) {
            return refreshConfiguration(RefreshConfiguration.builder().applyMutation(refreshConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RefreshConfiguration refreshConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetRefreshProperties model) {
            refreshConfiguration(model.refreshConfiguration);
        }

        public final RefreshConfiguration.Builder getRefreshConfiguration() {
            return refreshConfiguration != null ? refreshConfiguration.toBuilder() : null;
        }

        public final void setRefreshConfiguration(RefreshConfiguration.BuilderImpl refreshConfiguration) {
            this.refreshConfiguration = refreshConfiguration != null ? refreshConfiguration.build() : null;
        }

        @Override
        public final Builder refreshConfiguration(RefreshConfiguration refreshConfiguration) {
            this.refreshConfiguration = refreshConfiguration;
            return this;
        }

        @Override
        public DataSetRefreshProperties build() {
            return new DataSetRefreshProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
