/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allows data paths to be sorted by a specific data value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataPathSort implements SdkPojo, Serializable, ToCopyableBuilder<DataPathSort.Builder, DataPathSort> {
    private static final SdkField<String> DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Direction").getter(getter(DataPathSort::directionAsString)).setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()).build();

    private static final SdkField<List<DataPathValue>> SORT_PATHS_FIELD = SdkField
            .<List<DataPathValue>> builder(MarshallingType.LIST)
            .memberName("SortPaths")
            .getter(getter(DataPathSort::sortPaths))
            .setter(setter(Builder::sortPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortPaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataPathValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataPathValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTION_FIELD,
            SORT_PATHS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String direction;

    private final List<DataPathValue> sortPaths;

    private DataPathSort(BuilderImpl builder) {
        this.direction = builder.direction;
        this.sortPaths = builder.sortPaths;
    }

    /**
     * <p>
     * Determines the sort direction.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link SortDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return Determines the sort direction.
     * @see SortDirection
     */
    public final SortDirection direction() {
        return SortDirection.fromValue(direction);
    }

    /**
     * <p>
     * Determines the sort direction.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link SortDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return Determines the sort direction.
     * @see SortDirection
     */
    public final String directionAsString() {
        return direction;
    }

    /**
     * For responses, this returns true if the service returned a value for the SortPaths property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSortPaths() {
        return sortPaths != null && !(sortPaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of data paths that need to be sorted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSortPaths} method.
     * </p>
     * 
     * @return The list of data paths that need to be sorted.
     */
    public final List<DataPathValue> sortPaths() {
        return sortPaths;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSortPaths() ? sortPaths() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPathSort)) {
            return false;
        }
        DataPathSort other = (DataPathSort) obj;
        return Objects.equals(directionAsString(), other.directionAsString()) && hasSortPaths() == other.hasSortPaths()
                && Objects.equals(sortPaths(), other.sortPaths());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataPathSort").add("Direction", directionAsString())
                .add("SortPaths", hasSortPaths() ? sortPaths() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Direction":
            return Optional.ofNullable(clazz.cast(directionAsString()));
        case "SortPaths":
            return Optional.ofNullable(clazz.cast(sortPaths()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataPathSort, T> g) {
        return obj -> g.apply((DataPathSort) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataPathSort> {
        /**
         * <p>
         * Determines the sort direction.
         * </p>
         * 
         * @param direction
         *        Determines the sort direction.
         * @see SortDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortDirection
         */
        Builder direction(String direction);

        /**
         * <p>
         * Determines the sort direction.
         * </p>
         * 
         * @param direction
         *        Determines the sort direction.
         * @see SortDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortDirection
         */
        Builder direction(SortDirection direction);

        /**
         * <p>
         * The list of data paths that need to be sorted.
         * </p>
         * 
         * @param sortPaths
         *        The list of data paths that need to be sorted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortPaths(Collection<DataPathValue> sortPaths);

        /**
         * <p>
         * The list of data paths that need to be sorted.
         * </p>
         * 
         * @param sortPaths
         *        The list of data paths that need to be sorted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortPaths(DataPathValue... sortPaths);

        /**
         * <p>
         * The list of data paths that need to be sorted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DataPathValue.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DataPathValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DataPathValue.Builder#build()} is called immediately
         * and its result is passed to {@link #sortPaths(List<DataPathValue>)}.
         * 
         * @param sortPaths
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DataPathValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortPaths(java.util.Collection<DataPathValue>)
         */
        Builder sortPaths(Consumer<DataPathValue.Builder>... sortPaths);
    }

    static final class BuilderImpl implements Builder {
        private String direction;

        private List<DataPathValue> sortPaths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataPathSort model) {
            direction(model.direction);
            sortPaths(model.sortPaths);
        }

        public final String getDirection() {
            return direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(SortDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final List<DataPathValue.Builder> getSortPaths() {
            List<DataPathValue.Builder> result = DataPathValueListCopier.copyToBuilder(this.sortPaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortPaths(Collection<DataPathValue.BuilderImpl> sortPaths) {
            this.sortPaths = DataPathValueListCopier.copyFromBuilder(sortPaths);
        }

        @Override
        public final Builder sortPaths(Collection<DataPathValue> sortPaths) {
            this.sortPaths = DataPathValueListCopier.copy(sortPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortPaths(DataPathValue... sortPaths) {
            sortPaths(Arrays.asList(sortPaths));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortPaths(Consumer<DataPathValue.Builder>... sortPaths) {
            sortPaths(Stream.of(sortPaths).map(c -> DataPathValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DataPathSort build() {
            return new DataPathSort(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
