/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The contribution analysis visual display for a line, pie, or bar chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContributionAnalysisDefault implements SdkPojo, Serializable,
        ToCopyableBuilder<ContributionAnalysisDefault.Builder, ContributionAnalysisDefault> {
    private static final SdkField<String> MEASURE_FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeasureFieldId").getter(getter(ContributionAnalysisDefault::measureFieldId))
            .setter(setter(Builder::measureFieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureFieldId").build()).build();

    private static final SdkField<List<ColumnIdentifier>> CONTRIBUTOR_DIMENSIONS_FIELD = SdkField
            .<List<ColumnIdentifier>> builder(MarshallingType.LIST)
            .memberName("ContributorDimensions")
            .getter(getter(ContributionAnalysisDefault::contributorDimensions))
            .setter(setter(Builder::contributorDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributorDimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEASURE_FIELD_ID_FIELD,
            CONTRIBUTOR_DIMENSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String measureFieldId;

    private final List<ColumnIdentifier> contributorDimensions;

    private ContributionAnalysisDefault(BuilderImpl builder) {
        this.measureFieldId = builder.measureFieldId;
        this.contributorDimensions = builder.contributorDimensions;
    }

    /**
     * <p>
     * The measure field that is used in the contribution analysis.
     * </p>
     * 
     * @return The measure field that is used in the contribution analysis.
     */
    public final String measureFieldId() {
        return measureFieldId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContributorDimensions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasContributorDimensions() {
        return contributorDimensions != null && !(contributorDimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dimensions columns that are used in the contribution analysis, usually a list of
     * <code>ColumnIdentifiers</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContributorDimensions} method.
     * </p>
     * 
     * @return The dimensions columns that are used in the contribution analysis, usually a list of
     *         <code>ColumnIdentifiers</code>.
     */
    public final List<ColumnIdentifier> contributorDimensions() {
        return contributorDimensions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(measureFieldId());
        hashCode = 31 * hashCode + Objects.hashCode(hasContributorDimensions() ? contributorDimensions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContributionAnalysisDefault)) {
            return false;
        }
        ContributionAnalysisDefault other = (ContributionAnalysisDefault) obj;
        return Objects.equals(measureFieldId(), other.measureFieldId())
                && hasContributorDimensions() == other.hasContributorDimensions()
                && Objects.equals(contributorDimensions(), other.contributorDimensions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContributionAnalysisDefault").add("MeasureFieldId", measureFieldId())
                .add("ContributorDimensions", hasContributorDimensions() ? contributorDimensions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MeasureFieldId":
            return Optional.ofNullable(clazz.cast(measureFieldId()));
        case "ContributorDimensions":
            return Optional.ofNullable(clazz.cast(contributorDimensions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContributionAnalysisDefault, T> g) {
        return obj -> g.apply((ContributionAnalysisDefault) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContributionAnalysisDefault> {
        /**
         * <p>
         * The measure field that is used in the contribution analysis.
         * </p>
         * 
         * @param measureFieldId
         *        The measure field that is used in the contribution analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder measureFieldId(String measureFieldId);

        /**
         * <p>
         * The dimensions columns that are used in the contribution analysis, usually a list of
         * <code>ColumnIdentifiers</code>.
         * </p>
         * 
         * @param contributorDimensions
         *        The dimensions columns that are used in the contribution analysis, usually a list of
         *        <code>ColumnIdentifiers</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributorDimensions(Collection<ColumnIdentifier> contributorDimensions);

        /**
         * <p>
         * The dimensions columns that are used in the contribution analysis, usually a list of
         * <code>ColumnIdentifiers</code>.
         * </p>
         * 
         * @param contributorDimensions
         *        The dimensions columns that are used in the contribution analysis, usually a list of
         *        <code>ColumnIdentifiers</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributorDimensions(ColumnIdentifier... contributorDimensions);

        /**
         * <p>
         * The dimensions columns that are used in the contribution analysis, usually a list of
         * <code>ColumnIdentifiers</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnIdentifier.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #contributorDimensions(List<ColumnIdentifier>)}.
         * 
         * @param contributorDimensions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contributorDimensions(java.util.Collection<ColumnIdentifier>)
         */
        Builder contributorDimensions(Consumer<ColumnIdentifier.Builder>... contributorDimensions);
    }

    static final class BuilderImpl implements Builder {
        private String measureFieldId;

        private List<ColumnIdentifier> contributorDimensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContributionAnalysisDefault model) {
            measureFieldId(model.measureFieldId);
            contributorDimensions(model.contributorDimensions);
        }

        public final String getMeasureFieldId() {
            return measureFieldId;
        }

        public final void setMeasureFieldId(String measureFieldId) {
            this.measureFieldId = measureFieldId;
        }

        @Override
        public final Builder measureFieldId(String measureFieldId) {
            this.measureFieldId = measureFieldId;
            return this;
        }

        public final List<ColumnIdentifier.Builder> getContributorDimensions() {
            List<ColumnIdentifier.Builder> result = ContributorDimensionListCopier.copyToBuilder(this.contributorDimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContributorDimensions(Collection<ColumnIdentifier.BuilderImpl> contributorDimensions) {
            this.contributorDimensions = ContributorDimensionListCopier.copyFromBuilder(contributorDimensions);
        }

        @Override
        public final Builder contributorDimensions(Collection<ColumnIdentifier> contributorDimensions) {
            this.contributorDimensions = ContributorDimensionListCopier.copy(contributorDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributorDimensions(ColumnIdentifier... contributorDimensions) {
            contributorDimensions(Arrays.asList(contributorDimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributorDimensions(Consumer<ColumnIdentifier.Builder>... contributorDimensions) {
            contributorDimensions(Stream.of(contributorDimensions).map(c -> ColumnIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ContributionAnalysisDefault build() {
            return new ContributionAnalysisDefault(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
