/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AccountInfo;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccountSubscriptionResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeAccountSubscriptionResponse> {
    private static final SdkField<AccountInfo> ACCOUNT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccountInfo").getter(DescribeAccountSubscriptionResponse.getter(DescribeAccountSubscriptionResponse::accountInfo)).setter(DescribeAccountSubscriptionResponse.setter(Builder::accountInfo)).constructor(AccountInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountInfo").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeAccountSubscriptionResponse.getter(DescribeAccountSubscriptionResponse::status)).setter(DescribeAccountSubscriptionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeAccountSubscriptionResponse.getter(DescribeAccountSubscriptionResponse::requestId)).setter(DescribeAccountSubscriptionResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_INFO_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private final AccountInfo accountInfo;
    private final Integer status;
    private final String requestId;

    private DescribeAccountSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.accountInfo = builder.accountInfo;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public final AccountInfo accountInfo() {
        return this.accountInfo;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountSubscriptionResponse)) {
            return false;
        }
        DescribeAccountSubscriptionResponse other = (DescribeAccountSubscriptionResponse)((Object)obj);
        return Objects.equals(this.accountInfo(), other.accountInfo()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAccountSubscriptionResponse").add("AccountInfo", (Object)this.accountInfo()).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountInfo": {
                return Optional.ofNullable(clazz.cast(this.accountInfo()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountSubscriptionResponse, T> g) {
        return obj -> g.apply((DescribeAccountSubscriptionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private AccountInfo accountInfo;
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountSubscriptionResponse model) {
            super(model);
            this.accountInfo(model.accountInfo);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final AccountInfo.Builder getAccountInfo() {
            return this.accountInfo != null ? this.accountInfo.toBuilder() : null;
        }

        public final void setAccountInfo(AccountInfo.BuilderImpl accountInfo) {
            this.accountInfo = accountInfo != null ? accountInfo.build() : null;
        }

        @Override
        public final Builder accountInfo(AccountInfo accountInfo) {
            this.accountInfo = accountInfo;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public DescribeAccountSubscriptionResponse build() {
            return new DescribeAccountSubscriptionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccountSubscriptionResponse> {
        public Builder accountInfo(AccountInfo var1);

        default public Builder accountInfo(Consumer<AccountInfo.Builder> accountInfo) {
            return this.accountInfo((AccountInfo)((AccountInfo.Builder)AccountInfo.builder().applyMutation(accountInfo)).build());
        }

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

