/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ColumnDataSubType;
import software.amazon.awssdk.services.quicksight.model.InputColumnDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputColumn
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputColumn> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(InputColumn.getter(InputColumn::name)).setter(InputColumn.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(InputColumn.getter(InputColumn::typeAsString)).setter(InputColumn.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> SUB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubType").getter(InputColumn.getter(InputColumn::subTypeAsString)).setter(InputColumn.setter(Builder::subType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, SUB_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final String subType;

    private InputColumn(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.subType = builder.subType;
    }

    public final String name() {
        return this.name;
    }

    public final InputColumnDataType type() {
        return InputColumnDataType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final ColumnDataSubType subType() {
        return ColumnDataSubType.fromValue(this.subType);
    }

    public final String subTypeAsString() {
        return this.subType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputColumn)) {
            return false;
        }
        InputColumn other = (InputColumn)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.subTypeAsString(), other.subTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InputColumn").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("SubType", (Object)this.subTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "SubType": {
                return Optional.ofNullable(clazz.cast(this.subTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputColumn, T> g) {
        return obj -> g.apply((InputColumn)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String subType;

        private BuilderImpl() {
        }

        private BuilderImpl(InputColumn model) {
            this.name(model.name);
            this.type(model.type);
            this.subType(model.subType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InputColumnDataType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSubType() {
            return this.subType;
        }

        public final void setSubType(String subType) {
            this.subType = subType;
        }

        @Override
        public final Builder subType(String subType) {
            this.subType = subType;
            return this;
        }

        @Override
        public final Builder subType(ColumnDataSubType subType) {
            this.subType(subType == null ? null : subType.toString());
            return this;
        }

        public InputColumn build() {
            return new InputColumn(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputColumn> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(InputColumnDataType var1);

        public Builder subType(String var1);

        public Builder subType(ColumnDataSubType var1);
    }
}

