/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.ResourcePermission;

public class DescribeFolderPermissionsPublisher
implements SdkPublisher<DescribeFolderPermissionsResponse> {
    private final QuickSightAsyncClient client;
    private final DescribeFolderPermissionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeFolderPermissionsPublisher(QuickSightAsyncClient client, DescribeFolderPermissionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeFolderPermissionsPublisher(QuickSightAsyncClient client, DescribeFolderPermissionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeFolderPermissionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeFolderPermissionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourcePermission> permissions() {
        Function<DescribeFolderPermissionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.permissions() != null) {
                return response.permissions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeFolderPermissionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeFolderPermissionsResponseFetcher
    implements AsyncPageFetcher<DescribeFolderPermissionsResponse> {
        private DescribeFolderPermissionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFolderPermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeFolderPermissionsResponse> nextPage(DescribeFolderPermissionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeFolderPermissionsPublisher.this.client.describeFolderPermissions(DescribeFolderPermissionsPublisher.this.firstRequest);
            }
            return DescribeFolderPermissionsPublisher.this.client.describeFolderPermissions((DescribeFolderPermissionsRequest)((Object)DescribeFolderPermissionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

