/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.StarburstProductType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StarburstParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StarburstParameters> {
    private static final SdkField<String> HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Host").getter(StarburstParameters.getter(StarburstParameters::host)).setter(StarburstParameters.setter(Builder::host)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(StarburstParameters.getter(StarburstParameters::port)).setter(StarburstParameters.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(StarburstParameters.getter(StarburstParameters::catalog)).setter(StarburstParameters.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductType").getter(StarburstParameters.getter(StarburstParameters::productTypeAsString)).setter(StarburstParameters.setter(Builder::productType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, PORT_FIELD, CATALOG_FIELD, PRODUCT_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String host;
    private final Integer port;
    private final String catalog;
    private final String productType;

    private StarburstParameters(BuilderImpl builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.catalog = builder.catalog;
        this.productType = builder.productType;
    }

    public final String host() {
        return this.host;
    }

    public final Integer port() {
        return this.port;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final StarburstProductType productType() {
        return StarburstProductType.fromValue(this.productType);
    }

    public final String productTypeAsString() {
        return this.productType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.productTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StarburstParameters)) {
            return false;
        }
        StarburstParameters other = (StarburstParameters)obj;
        return Objects.equals(this.host(), other.host()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.productTypeAsString(), other.productTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StarburstParameters").add("Host", (Object)this.host()).add("Port", (Object)this.port()).add("Catalog", (Object)this.catalog()).add("ProductType", (Object)this.productTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "ProductType": {
                return Optional.ofNullable(clazz.cast(this.productTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StarburstParameters, T> g) {
        return obj -> g.apply((StarburstParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String host;
        private Integer port;
        private String catalog;
        private String productType;

        private BuilderImpl() {
        }

        private BuilderImpl(StarburstParameters model) {
            this.host(model.host);
            this.port(model.port);
            this.catalog(model.catalog);
            this.productType(model.productType);
        }

        public final String getHost() {
            return this.host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getProductType() {
            return this.productType;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(StarburstProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public StarburstParameters build() {
            return new StarburstParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StarburstParameters> {
        public Builder host(String var1);

        public Builder port(Integer var1);

        public Builder catalog(String var1);

        public Builder productType(String var1);

        public Builder productType(StarburstProductType var1);
    }
}

