/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CrossDatasetTypes {
    ALL_DATASETS("ALL_DATASETS"),
    SINGLE_DATASET("SINGLE_DATASET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CrossDatasetTypes> VALUE_MAP;
    private final String value;

    private CrossDatasetTypes(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CrossDatasetTypes fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CrossDatasetTypes> knownValues() {
        EnumSet<CrossDatasetTypes> knownValues = EnumSet.allOf(CrossDatasetTypes.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CrossDatasetTypes.class, CrossDatasetTypes::toString);
    }
}

