/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.LinkEntityArnListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDashboardLinksResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, UpdateDashboardLinksResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(UpdateDashboardLinksResponse.getter(UpdateDashboardLinksResponse::requestId)).setter(UpdateDashboardLinksResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(UpdateDashboardLinksResponse.getter(UpdateDashboardLinksResponse::status)).setter(UpdateDashboardLinksResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> DASHBOARD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardArn").getter(UpdateDashboardLinksResponse.getter(UpdateDashboardLinksResponse::dashboardArn)).setter(UpdateDashboardLinksResponse.setter(Builder::dashboardArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardArn").build()}).build();
    private static final SdkField<List<String>> LINK_ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LinkEntities").getter(UpdateDashboardLinksResponse.getter(UpdateDashboardLinksResponse::linkEntities)).setter(UpdateDashboardLinksResponse.setter(Builder::linkEntities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkEntities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, STATUS_FIELD, DASHBOARD_ARN_FIELD, LINK_ENTITIES_FIELD));
    private final String requestId;
    private final Integer status;
    private final String dashboardArn;
    private final List<String> linkEntities;

    private UpdateDashboardLinksResponse(BuilderImpl builder) {
        super(builder);
        this.requestId = builder.requestId;
        this.status = builder.status;
        this.dashboardArn = builder.dashboardArn;
        this.linkEntities = builder.linkEntities;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public final String dashboardArn() {
        return this.dashboardArn;
    }

    public final boolean hasLinkEntities() {
        return this.linkEntities != null && !(this.linkEntities instanceof SdkAutoConstructList);
    }

    public final List<String> linkEntities() {
        return this.linkEntities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinkEntities() ? this.linkEntities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDashboardLinksResponse)) {
            return false;
        }
        UpdateDashboardLinksResponse other = (UpdateDashboardLinksResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.dashboardArn(), other.dashboardArn()) && this.hasLinkEntities() == other.hasLinkEntities() && Objects.equals(this.linkEntities(), other.linkEntities());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDashboardLinksResponse").add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).add("DashboardArn", (Object)this.dashboardArn()).add("LinkEntities", this.hasLinkEntities() ? this.linkEntities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "DashboardArn": {
                return Optional.ofNullable(clazz.cast(this.dashboardArn()));
            }
            case "LinkEntities": {
                return Optional.ofNullable(clazz.cast(this.linkEntities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDashboardLinksResponse, T> g) {
        return obj -> g.apply((UpdateDashboardLinksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String requestId;
        private Integer status;
        private String dashboardArn;
        private List<String> linkEntities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDashboardLinksResponse model) {
            super(model);
            this.requestId(model.requestId);
            this.status(model.status);
            this.dashboardArn(model.dashboardArn);
            this.linkEntities(model.linkEntities);
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getDashboardArn() {
            return this.dashboardArn;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final Collection<String> getLinkEntities() {
            if (this.linkEntities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.linkEntities;
        }

        public final void setLinkEntities(Collection<String> linkEntities) {
            this.linkEntities = LinkEntityArnListCopier.copy(linkEntities);
        }

        @Override
        public final Builder linkEntities(Collection<String> linkEntities) {
            this.linkEntities = LinkEntityArnListCopier.copy(linkEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkEntities(String ... linkEntities) {
            this.linkEntities(Arrays.asList(linkEntities));
            return this;
        }

        @Override
        public UpdateDashboardLinksResponse build() {
            return new UpdateDashboardLinksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDashboardLinksResponse> {
        public Builder requestId(String var1);

        public Builder status(Integer var1);

        public Builder dashboardArn(String var1);

        public Builder linkEntities(Collection<String> var1);

        public Builder linkEntities(String ... var1);
    }
}

