/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ListFolderMembersRequest;
import software.amazon.awssdk.services.quicksight.model.ListFolderMembersResponse;
import software.amazon.awssdk.services.quicksight.model.MemberIdArnPair;

public class ListFolderMembersIterable
implements SdkIterable<ListFolderMembersResponse> {
    private final QuickSightClient client;
    private final ListFolderMembersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFolderMembersIterable(QuickSightClient client, ListFolderMembersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFolderMembersResponseFetcher();
    }

    public Iterator<ListFolderMembersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MemberIdArnPair> folderMemberList() {
        Function<ListFolderMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.folderMemberList() != null) {
                return response.folderMemberList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFolderMembersResponseFetcher
    implements SyncPageFetcher<ListFolderMembersResponse> {
        private ListFolderMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListFolderMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFolderMembersResponse nextPage(ListFolderMembersResponse previousPage) {
            if (previousPage == null) {
                return ListFolderMembersIterable.this.client.listFolderMembers(ListFolderMembersIterable.this.firstRequest);
            }
            return ListFolderMembersIterable.this.client.listFolderMembers((ListFolderMembersRequest)((Object)ListFolderMembersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

