/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.IpRestrictionRuleMapCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIpRestrictionRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateIpRestrictionRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateIpRestrictionRequest.getter(UpdateIpRestrictionRequest::awsAccountId)).setter(UpdateIpRestrictionRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<Map<String, String>> IP_RESTRICTION_RULE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("IpRestrictionRuleMap").getter(UpdateIpRestrictionRequest.getter(UpdateIpRestrictionRequest::ipRestrictionRuleMap)).setter(UpdateIpRestrictionRequest.setter(Builder::ipRestrictionRuleMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRestrictionRuleMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(UpdateIpRestrictionRequest.getter(UpdateIpRestrictionRequest::enabled)).setter(UpdateIpRestrictionRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, IP_RESTRICTION_RULE_MAP_FIELD, ENABLED_FIELD));
    private final String awsAccountId;
    private final Map<String, String> ipRestrictionRuleMap;
    private final Boolean enabled;

    private UpdateIpRestrictionRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.ipRestrictionRuleMap = builder.ipRestrictionRuleMap;
        this.enabled = builder.enabled;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final boolean hasIpRestrictionRuleMap() {
        return this.ipRestrictionRuleMap != null && !(this.ipRestrictionRuleMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> ipRestrictionRuleMap() {
        return this.ipRestrictionRuleMap;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpRestrictionRuleMap() ? this.ipRestrictionRuleMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIpRestrictionRequest)) {
            return false;
        }
        UpdateIpRestrictionRequest other = (UpdateIpRestrictionRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && this.hasIpRestrictionRuleMap() == other.hasIpRestrictionRuleMap() && Objects.equals(this.ipRestrictionRuleMap(), other.ipRestrictionRuleMap()) && Objects.equals(this.enabled(), other.enabled());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIpRestrictionRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("IpRestrictionRuleMap", this.hasIpRestrictionRuleMap() ? this.ipRestrictionRuleMap() : null).add("Enabled", (Object)this.enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "IpRestrictionRuleMap": {
                return Optional.ofNullable(clazz.cast(this.ipRestrictionRuleMap()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIpRestrictionRequest, T> g) {
        return obj -> g.apply((UpdateIpRestrictionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private Map<String, String> ipRestrictionRuleMap = DefaultSdkAutoConstructMap.getInstance();
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIpRestrictionRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.ipRestrictionRuleMap(model.ipRestrictionRuleMap);
            this.enabled(model.enabled);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Map<String, String> getIpRestrictionRuleMap() {
            if (this.ipRestrictionRuleMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.ipRestrictionRuleMap;
        }

        public final void setIpRestrictionRuleMap(Map<String, String> ipRestrictionRuleMap) {
            this.ipRestrictionRuleMap = IpRestrictionRuleMapCopier.copy(ipRestrictionRuleMap);
        }

        @Override
        public final Builder ipRestrictionRuleMap(Map<String, String> ipRestrictionRuleMap) {
            this.ipRestrictionRuleMap = IpRestrictionRuleMapCopier.copy(ipRestrictionRuleMap);
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIpRestrictionRequest build() {
            return new UpdateIpRestrictionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIpRestrictionRequest> {
        public Builder awsAccountId(String var1);

        public Builder ipRestrictionRuleMap(Map<String, String> var1);

        public Builder enabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

