/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AssetBundleRestrictiveResourceIdListCopier;
import software.amazon.awssdk.services.quicksight.model.Tag;
import software.amazon.awssdk.services.quicksight.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetBundleImportJobVPCConnectionOverrideTags
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetBundleImportJobVPCConnectionOverrideTags> {
    private static final SdkField<List<String>> VPC_CONNECTION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VPCConnectionIds").getter(AssetBundleImportJobVPCConnectionOverrideTags.getter(AssetBundleImportJobVPCConnectionOverrideTags::vpcConnectionIds)).setter(AssetBundleImportJobVPCConnectionOverrideTags.setter(Builder::vpcConnectionIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCConnectionIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(AssetBundleImportJobVPCConnectionOverrideTags.getter(AssetBundleImportJobVPCConnectionOverrideTags::tags)).setter(AssetBundleImportJobVPCConnectionOverrideTags.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTION_IDS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> vpcConnectionIds;
    private final List<Tag> tags;

    private AssetBundleImportJobVPCConnectionOverrideTags(BuilderImpl builder) {
        this.vpcConnectionIds = builder.vpcConnectionIds;
        this.tags = builder.tags;
    }

    public final boolean hasVpcConnectionIds() {
        return this.vpcConnectionIds != null && !(this.vpcConnectionIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcConnectionIds() {
        return this.vpcConnectionIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcConnectionIds() ? this.vpcConnectionIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobVPCConnectionOverrideTags)) {
            return false;
        }
        AssetBundleImportJobVPCConnectionOverrideTags other = (AssetBundleImportJobVPCConnectionOverrideTags)obj;
        return this.hasVpcConnectionIds() == other.hasVpcConnectionIds() && Objects.equals(this.vpcConnectionIds(), other.vpcConnectionIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"AssetBundleImportJobVPCConnectionOverrideTags").add("VPCConnectionIds", this.hasVpcConnectionIds() ? this.vpcConnectionIds() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VPCConnectionIds": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobVPCConnectionOverrideTags, T> g) {
        return obj -> g.apply((AssetBundleImportJobVPCConnectionOverrideTags)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> vpcConnectionIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobVPCConnectionOverrideTags model) {
            this.vpcConnectionIds(model.vpcConnectionIds);
            this.tags(model.tags);
        }

        public final Collection<String> getVpcConnectionIds() {
            if (this.vpcConnectionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcConnectionIds;
        }

        public final void setVpcConnectionIds(Collection<String> vpcConnectionIds) {
            this.vpcConnectionIds = AssetBundleRestrictiveResourceIdListCopier.copy(vpcConnectionIds);
        }

        @Override
        public final Builder vpcConnectionIds(Collection<String> vpcConnectionIds) {
            this.vpcConnectionIds = AssetBundleRestrictiveResourceIdListCopier.copy(vpcConnectionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConnectionIds(String ... vpcConnectionIds) {
            this.vpcConnectionIds(Arrays.asList(vpcConnectionIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AssetBundleImportJobVPCConnectionOverrideTags build() {
            return new AssetBundleImportJobVPCConnectionOverrideTags(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetBundleImportJobVPCConnectionOverrideTags> {
        public Builder vpcConnectionIds(Collection<String> var1);

        public Builder vpcConnectionIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

