/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StarburstProductType {
    GALAXY("GALAXY"),
    ENTERPRISE("ENTERPRISE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StarburstProductType> VALUE_MAP;
    private final String value;

    private StarburstProductType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StarburstProductType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StarburstProductType> knownValues() {
        EnumSet<StarburstProductType> knownValues = EnumSet.allOf(StarburstProductType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StarburstProductType.class, StarburstProductType::toString);
    }
}

