/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AssignmentStatus;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIamPolicyAssignmentsRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, ListIamPolicyAssignmentsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(ListIamPolicyAssignmentsRequest.getter(ListIamPolicyAssignmentsRequest::awsAccountId)).setter(ListIamPolicyAssignmentsRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> ASSIGNMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignmentStatus").getter(ListIamPolicyAssignmentsRequest.getter(ListIamPolicyAssignmentsRequest::assignmentStatusAsString)).setter(ListIamPolicyAssignmentsRequest.setter(Builder::assignmentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assignment-status").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(ListIamPolicyAssignmentsRequest.getter(ListIamPolicyAssignmentsRequest::namespace)).setter(ListIamPolicyAssignmentsRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIamPolicyAssignmentsRequest.getter(ListIamPolicyAssignmentsRequest::nextToken)).setter(ListIamPolicyAssignmentsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListIamPolicyAssignmentsRequest.getter(ListIamPolicyAssignmentsRequest::maxResults)).setter(ListIamPolicyAssignmentsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, ASSIGNMENT_STATUS_FIELD, NAMESPACE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String awsAccountId;
    private final String assignmentStatus;
    private final String namespace;
    private final String nextToken;
    private final Integer maxResults;

    private ListIamPolicyAssignmentsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.assignmentStatus = builder.assignmentStatus;
        this.namespace = builder.namespace;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final AssignmentStatus assignmentStatus() {
        return AssignmentStatus.fromValue(this.assignmentStatus);
    }

    public final String assignmentStatusAsString() {
        return this.assignmentStatus;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIamPolicyAssignmentsRequest)) {
            return false;
        }
        ListIamPolicyAssignmentsRequest other = (ListIamPolicyAssignmentsRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.assignmentStatusAsString(), other.assignmentStatusAsString()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListIamPolicyAssignmentsRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("AssignmentStatus", (Object)this.assignmentStatusAsString()).add("Namespace", (Object)this.namespace()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "AssignmentStatus": {
                return Optional.ofNullable(clazz.cast(this.assignmentStatusAsString()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIamPolicyAssignmentsRequest, T> g) {
        return obj -> g.apply((ListIamPolicyAssignmentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String assignmentStatus;
        private String namespace;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIamPolicyAssignmentsRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.assignmentStatus(model.assignmentStatus);
            this.namespace(model.namespace);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAssignmentStatus() {
            return this.assignmentStatus;
        }

        public final void setAssignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
        }

        @Override
        public final Builder assignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            return this;
        }

        @Override
        public final Builder assignmentStatus(AssignmentStatus assignmentStatus) {
            this.assignmentStatus(assignmentStatus == null ? null : assignmentStatus.toString());
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIamPolicyAssignmentsRequest build() {
            return new ListIamPolicyAssignmentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIamPolicyAssignmentsRequest> {
        public Builder awsAccountId(String var1);

        public Builder assignmentStatus(String var1);

        public Builder assignmentStatus(AssignmentStatus var1);

        public Builder namespace(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

