/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportFailureAction;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetBundleImportJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetBundleImportJobSummary> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(AssetBundleImportJobSummary.getter(AssetBundleImportJobSummary::jobStatusAsString)).setter(AssetBundleImportJobSummary.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AssetBundleImportJobSummary.getter(AssetBundleImportJobSummary::arn)).setter(AssetBundleImportJobSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(AssetBundleImportJobSummary.getter(AssetBundleImportJobSummary::createdTime)).setter(AssetBundleImportJobSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> ASSET_BUNDLE_IMPORT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssetBundleImportJobId").getter(AssetBundleImportJobSummary.getter(AssetBundleImportJobSummary::assetBundleImportJobId)).setter(AssetBundleImportJobSummary.setter(Builder::assetBundleImportJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleImportJobId").build()}).build();
    private static final SdkField<String> FAILURE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureAction").getter(AssetBundleImportJobSummary.getter(AssetBundleImportJobSummary::failureActionAsString)).setter(AssetBundleImportJobSummary.setter(Builder::failureAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD, ARN_FIELD, CREATED_TIME_FIELD, ASSET_BUNDLE_IMPORT_JOB_ID_FIELD, FAILURE_ACTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobStatus;
    private final String arn;
    private final Instant createdTime;
    private final String assetBundleImportJobId;
    private final String failureAction;

    private AssetBundleImportJobSummary(BuilderImpl builder) {
        this.jobStatus = builder.jobStatus;
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.assetBundleImportJobId = builder.assetBundleImportJobId;
        this.failureAction = builder.failureAction;
    }

    public final AssetBundleImportJobStatus jobStatus() {
        return AssetBundleImportJobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String assetBundleImportJobId() {
        return this.assetBundleImportJobId;
    }

    public final AssetBundleImportFailureAction failureAction() {
        return AssetBundleImportFailureAction.fromValue(this.failureAction);
    }

    public final String failureActionAsString() {
        return this.failureAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetBundleImportJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureActionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobSummary)) {
            return false;
        }
        AssetBundleImportJobSummary other = (AssetBundleImportJobSummary)obj;
        return Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.assetBundleImportJobId(), other.assetBundleImportJobId()) && Objects.equals(this.failureActionAsString(), other.failureActionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AssetBundleImportJobSummary").add("JobStatus", (Object)this.jobStatusAsString()).add("Arn", (Object)this.arn()).add("CreatedTime", (Object)this.createdTime()).add("AssetBundleImportJobId", (Object)this.assetBundleImportJobId()).add("FailureAction", (Object)this.failureActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "AssetBundleImportJobId": {
                return Optional.ofNullable(clazz.cast(this.assetBundleImportJobId()));
            }
            case "FailureAction": {
                return Optional.ofNullable(clazz.cast(this.failureActionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobSummary, T> g) {
        return obj -> g.apply((AssetBundleImportJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobStatus;
        private String arn;
        private Instant createdTime;
        private String assetBundleImportJobId;
        private String failureAction;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobSummary model) {
            this.jobStatus(model.jobStatus);
            this.arn(model.arn);
            this.createdTime(model.createdTime);
            this.assetBundleImportJobId(model.assetBundleImportJobId);
            this.failureAction(model.failureAction);
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(AssetBundleImportJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getAssetBundleImportJobId() {
            return this.assetBundleImportJobId;
        }

        public final void setAssetBundleImportJobId(String assetBundleImportJobId) {
            this.assetBundleImportJobId = assetBundleImportJobId;
        }

        @Override
        public final Builder assetBundleImportJobId(String assetBundleImportJobId) {
            this.assetBundleImportJobId = assetBundleImportJobId;
            return this;
        }

        public final String getFailureAction() {
            return this.failureAction;
        }

        public final void setFailureAction(String failureAction) {
            this.failureAction = failureAction;
        }

        @Override
        public final Builder failureAction(String failureAction) {
            this.failureAction = failureAction;
            return this;
        }

        @Override
        public final Builder failureAction(AssetBundleImportFailureAction failureAction) {
            this.failureAction(failureAction == null ? null : failureAction.toString());
            return this;
        }

        public AssetBundleImportJobSummary build() {
            return new AssetBundleImportJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetBundleImportJobSummary> {
        public Builder jobStatus(String var1);

        public Builder jobStatus(AssetBundleImportJobStatus var1);

        public Builder arn(String var1);

        public Builder createdTime(Instant var1);

        public Builder assetBundleImportJobId(String var1);

        public Builder failureAction(String var1);

        public Builder failureAction(AssetBundleImportFailureAction var1);
    }
}

