/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidationStrategyMode {
    STRICT("STRICT"),
    LENIENT("LENIENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidationStrategyMode> VALUE_MAP;
    private final String value;

    private ValidationStrategyMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationStrategyMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationStrategyMode> knownValues() {
        EnumSet<ValidationStrategyMode> knownValues = EnumSet.allOf(ValidationStrategyMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidationStrategyMode.class, ValidationStrategyMode::toString);
    }
}

