/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FreeFormLayoutElement;
import software.amazon.awssdk.services.quicksight.model.FreeFromLayoutElementListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FreeFormSectionLayoutConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FreeFormSectionLayoutConfiguration> {
    private static final SdkField<List<FreeFormLayoutElement>> ELEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Elements").getter(FreeFormSectionLayoutConfiguration.getter(FreeFormSectionLayoutConfiguration::elements)).setter(FreeFormSectionLayoutConfiguration.setter(Builder::elements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Elements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FreeFormLayoutElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<FreeFormLayoutElement> elements;

    private FreeFormSectionLayoutConfiguration(BuilderImpl builder) {
        this.elements = builder.elements;
    }

    public final boolean hasElements() {
        return this.elements != null && !(this.elements instanceof SdkAutoConstructList);
    }

    public final List<FreeFormLayoutElement> elements() {
        return this.elements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElements() ? this.elements() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FreeFormSectionLayoutConfiguration)) {
            return false;
        }
        FreeFormSectionLayoutConfiguration other = (FreeFormSectionLayoutConfiguration)obj;
        return this.hasElements() == other.hasElements() && Objects.equals(this.elements(), other.elements());
    }

    public final String toString() {
        return ToString.builder((String)"FreeFormSectionLayoutConfiguration").add("Elements", this.hasElements() ? this.elements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Elements": {
                return Optional.ofNullable(clazz.cast(this.elements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FreeFormSectionLayoutConfiguration, T> g) {
        return obj -> g.apply((FreeFormSectionLayoutConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FreeFormLayoutElement> elements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FreeFormSectionLayoutConfiguration model) {
            this.elements(model.elements);
        }

        public final List<FreeFormLayoutElement.Builder> getElements() {
            List<FreeFormLayoutElement.Builder> result = FreeFromLayoutElementListCopier.copyToBuilder(this.elements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElements(Collection<FreeFormLayoutElement.BuilderImpl> elements) {
            this.elements = FreeFromLayoutElementListCopier.copyFromBuilder(elements);
        }

        @Override
        public final Builder elements(Collection<FreeFormLayoutElement> elements) {
            this.elements = FreeFromLayoutElementListCopier.copy(elements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(FreeFormLayoutElement ... elements) {
            this.elements(Arrays.asList(elements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(Consumer<FreeFormLayoutElement.Builder> ... elements) {
            this.elements(Stream.of(elements).map(c -> (FreeFormLayoutElement)((FreeFormLayoutElement.Builder)FreeFormLayoutElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FreeFormSectionLayoutConfiguration build() {
            return new FreeFormSectionLayoutConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FreeFormSectionLayoutConfiguration> {
        public Builder elements(Collection<FreeFormLayoutElement> var1);

        public Builder elements(FreeFormLayoutElement ... var1);

        public Builder elements(Consumer<FreeFormLayoutElement.Builder> ... var1);
    }
}

