/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HistogramBinType {
    BIN_COUNT("BIN_COUNT"),
    BIN_WIDTH("BIN_WIDTH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HistogramBinType> VALUE_MAP;
    private final String value;

    private HistogramBinType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HistogramBinType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HistogramBinType> knownValues() {
        EnumSet<HistogramBinType> knownValues = EnumSet.allOf(HistogramBinType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HistogramBinType.class, HistogramBinType::toString);
    }
}

