/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.Group;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsResponse;

public class ListUserGroupsPublisher
implements SdkPublisher<ListUserGroupsResponse> {
    private final QuickSightAsyncClient client;
    private final ListUserGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUserGroupsPublisher(QuickSightAsyncClient client, ListUserGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUserGroupsPublisher(QuickSightAsyncClient client, ListUserGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUserGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUserGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Group> groupList() {
        Function<ListUserGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groupList() != null) {
                return response.groupList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUserGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUserGroupsResponseFetcher
    implements AsyncPageFetcher<ListUserGroupsResponse> {
        private ListUserGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListUserGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUserGroupsResponse> nextPage(ListUserGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListUserGroupsPublisher.this.client.listUserGroups(ListUserGroupsPublisher.this.firstRequest);
            }
            return ListUserGroupsPublisher.this.client.listUserGroups((ListUserGroupsRequest)((Object)ListUserGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

