/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.quicksight.DefaultQuickSightBaseClientBuilder;
import software.amazon.awssdk.services.quicksight.DefaultQuickSightClient;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.QuickSightClientBuilder;
import software.amazon.awssdk.services.quicksight.QuickSightServiceClientConfiguration;
import software.amazon.awssdk.services.quicksight.endpoints.QuickSightEndpointProvider;

@SdkInternalApi
final class DefaultQuickSightClientBuilder
extends DefaultQuickSightBaseClientBuilder<QuickSightClientBuilder, QuickSightClient>
implements QuickSightClientBuilder {
    DefaultQuickSightClientBuilder() {
    }

    @Override
    public DefaultQuickSightClientBuilder endpointProvider(QuickSightEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final QuickSightClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultQuickSightClientBuilder.validateClientOptions(clientConfiguration);
        QuickSightServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultQuickSightClient client = new DefaultQuickSightClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private QuickSightServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return QuickSightServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

