/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobSummary;
import software.amazon.awssdk.services.quicksight.model.ListAssetBundleExportJobsRequest;
import software.amazon.awssdk.services.quicksight.model.ListAssetBundleExportJobsResponse;

public class ListAssetBundleExportJobsPublisher
implements SdkPublisher<ListAssetBundleExportJobsResponse> {
    private final QuickSightAsyncClient client;
    private final ListAssetBundleExportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssetBundleExportJobsPublisher(QuickSightAsyncClient client, ListAssetBundleExportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssetBundleExportJobsPublisher(QuickSightAsyncClient client, ListAssetBundleExportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssetBundleExportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssetBundleExportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssetBundleExportJobSummary> assetBundleExportJobSummaryList() {
        Function<ListAssetBundleExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetBundleExportJobSummaryList() != null) {
                return response.assetBundleExportJobSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssetBundleExportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssetBundleExportJobsResponseFetcher
    implements AsyncPageFetcher<ListAssetBundleExportJobsResponse> {
        private ListAssetBundleExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetBundleExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssetBundleExportJobsResponse> nextPage(ListAssetBundleExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetBundleExportJobsPublisher.this.client.listAssetBundleExportJobs(ListAssetBundleExportJobsPublisher.this.firstRequest);
            }
            return ListAssetBundleExportJobsPublisher.this.client.listAssetBundleExportJobs((ListAssetBundleExportJobsRequest)((Object)ListAssetBundleExportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

