/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.model.ListTopicsRequest;
import software.amazon.awssdk.services.quicksight.model.ListTopicsResponse;

public class ListTopicsIterable
implements SdkIterable<ListTopicsResponse> {
    private final QuickSightClient client;
    private final ListTopicsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTopicsIterable(QuickSightClient client, ListTopicsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTopicsResponseFetcher();
    }

    public Iterator<ListTopicsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTopicsResponseFetcher
    implements SyncPageFetcher<ListTopicsResponse> {
        private ListTopicsResponseFetcher() {
        }

        public boolean hasNextPage(ListTopicsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTopicsResponse nextPage(ListTopicsResponse previousPage) {
            if (previousPage == null) {
                return ListTopicsIterable.this.client.listTopics(ListTopicsIterable.this.firstRequest);
            }
            return ListTopicsIterable.this.client.listTopics((ListTopicsRequest)((Object)ListTopicsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

