/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FilterClass {
    ENFORCED_VALUE_FILTER("ENFORCED_VALUE_FILTER"),
    CONDITIONAL_VALUE_FILTER("CONDITIONAL_VALUE_FILTER"),
    NAMED_VALUE_FILTER("NAMED_VALUE_FILTER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FilterClass> VALUE_MAP;
    private final String value;

    private FilterClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FilterClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FilterClass> knownValues() {
        EnumSet<FilterClass> knownValues = EnumSet.allOf(FilterClass.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FilterClass.class, FilterClass::toString);
    }
}

