/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.Edition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountInfo> {
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountName").getter(AccountInfo.getter(AccountInfo::accountName)).setter(AccountInfo.setter(Builder::accountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()}).build();
    private static final SdkField<String> EDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Edition").getter(AccountInfo.getter(AccountInfo::editionAsString)).setter(AccountInfo.setter(Builder::edition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()}).build();
    private static final SdkField<String> NOTIFICATION_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationEmail").getter(AccountInfo.getter(AccountInfo::notificationEmail)).setter(AccountInfo.setter(Builder::notificationEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationEmail").build()}).build();
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationType").getter(AccountInfo.getter(AccountInfo::authenticationType)).setter(AccountInfo.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build()}).build();
    private static final SdkField<String> ACCOUNT_SUBSCRIPTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountSubscriptionStatus").getter(AccountInfo.getter(AccountInfo::accountSubscriptionStatus)).setter(AccountInfo.setter(Builder::accountSubscriptionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountSubscriptionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NAME_FIELD, EDITION_FIELD, NOTIFICATION_EMAIL_FIELD, AUTHENTICATION_TYPE_FIELD, ACCOUNT_SUBSCRIPTION_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountName;
    private final String edition;
    private final String notificationEmail;
    private final String authenticationType;
    private final String accountSubscriptionStatus;

    private AccountInfo(BuilderImpl builder) {
        this.accountName = builder.accountName;
        this.edition = builder.edition;
        this.notificationEmail = builder.notificationEmail;
        this.authenticationType = builder.authenticationType;
        this.accountSubscriptionStatus = builder.accountSubscriptionStatus;
    }

    public final String accountName() {
        return this.accountName;
    }

    public final Edition edition() {
        return Edition.fromValue(this.edition);
    }

    public final String editionAsString() {
        return this.edition;
    }

    public final String notificationEmail() {
        return this.notificationEmail;
    }

    public final String authenticationType() {
        return this.authenticationType;
    }

    public final String accountSubscriptionStatus() {
        return this.accountSubscriptionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.editionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountSubscriptionStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountInfo)) {
            return false;
        }
        AccountInfo other = (AccountInfo)obj;
        return Objects.equals(this.accountName(), other.accountName()) && Objects.equals(this.editionAsString(), other.editionAsString()) && Objects.equals(this.notificationEmail(), other.notificationEmail()) && Objects.equals(this.authenticationType(), other.authenticationType()) && Objects.equals(this.accountSubscriptionStatus(), other.accountSubscriptionStatus());
    }

    public final String toString() {
        return ToString.builder((String)"AccountInfo").add("AccountName", (Object)this.accountName()).add("Edition", (Object)this.editionAsString()).add("NotificationEmail", (Object)this.notificationEmail()).add("AuthenticationType", (Object)this.authenticationType()).add("AccountSubscriptionStatus", (Object)this.accountSubscriptionStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountName": {
                return Optional.ofNullable(clazz.cast(this.accountName()));
            }
            case "Edition": {
                return Optional.ofNullable(clazz.cast(this.editionAsString()));
            }
            case "NotificationEmail": {
                return Optional.ofNullable(clazz.cast(this.notificationEmail()));
            }
            case "AuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationType()));
            }
            case "AccountSubscriptionStatus": {
                return Optional.ofNullable(clazz.cast(this.accountSubscriptionStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountInfo, T> g) {
        return obj -> g.apply((AccountInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountName;
        private String edition;
        private String notificationEmail;
        private String authenticationType;
        private String accountSubscriptionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountInfo model) {
            this.accountName(model.accountName);
            this.edition(model.edition);
            this.notificationEmail(model.notificationEmail);
            this.authenticationType(model.authenticationType);
            this.accountSubscriptionStatus(model.accountSubscriptionStatus);
        }

        public final String getAccountName() {
            return this.accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final String getEdition() {
            return this.edition;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        public final Builder edition(Edition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public final String getNotificationEmail() {
            return this.notificationEmail;
        }

        public final void setNotificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
        }

        @Override
        public final Builder notificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
            return this;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public final String getAccountSubscriptionStatus() {
            return this.accountSubscriptionStatus;
        }

        public final void setAccountSubscriptionStatus(String accountSubscriptionStatus) {
            this.accountSubscriptionStatus = accountSubscriptionStatus;
        }

        @Override
        public final Builder accountSubscriptionStatus(String accountSubscriptionStatus) {
            this.accountSubscriptionStatus = accountSubscriptionStatus;
            return this;
        }

        public AccountInfo build() {
            return new AccountInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountInfo> {
        public Builder accountName(String var1);

        public Builder edition(String var1);

        public Builder edition(Edition var1);

        public Builder notificationEmail(String var1);

        public Builder authenticationType(String var1);

        public Builder accountSubscriptionStatus(String var1);
    }
}

