/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.TargetVisualListCopier;
import software.amazon.awssdk.services.quicksight.model.TargetVisualOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SameSheetTargetVisualConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SameSheetTargetVisualConfiguration> {
    private static final SdkField<List<String>> TARGET_VISUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetVisuals").getter(SameSheetTargetVisualConfiguration.getter(SameSheetTargetVisualConfiguration::targetVisuals)).setter(SameSheetTargetVisualConfiguration.setter(Builder::targetVisuals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVisuals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_VISUAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetVisualOptions").getter(SameSheetTargetVisualConfiguration.getter(SameSheetTargetVisualConfiguration::targetVisualOptionsAsString)).setter(SameSheetTargetVisualConfiguration.setter(Builder::targetVisualOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVisualOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_VISUALS_FIELD, TARGET_VISUAL_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> targetVisuals;
    private final String targetVisualOptions;

    private SameSheetTargetVisualConfiguration(BuilderImpl builder) {
        this.targetVisuals = builder.targetVisuals;
        this.targetVisualOptions = builder.targetVisualOptions;
    }

    public final boolean hasTargetVisuals() {
        return this.targetVisuals != null && !(this.targetVisuals instanceof SdkAutoConstructList);
    }

    public final List<String> targetVisuals() {
        return this.targetVisuals;
    }

    public final TargetVisualOptions targetVisualOptions() {
        return TargetVisualOptions.fromValue(this.targetVisualOptions);
    }

    public final String targetVisualOptionsAsString() {
        return this.targetVisualOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetVisuals() ? this.targetVisuals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVisualOptionsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SameSheetTargetVisualConfiguration)) {
            return false;
        }
        SameSheetTargetVisualConfiguration other = (SameSheetTargetVisualConfiguration)obj;
        return this.hasTargetVisuals() == other.hasTargetVisuals() && Objects.equals(this.targetVisuals(), other.targetVisuals()) && Objects.equals(this.targetVisualOptionsAsString(), other.targetVisualOptionsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SameSheetTargetVisualConfiguration").add("TargetVisuals", this.hasTargetVisuals() ? this.targetVisuals() : null).add("TargetVisualOptions", (Object)this.targetVisualOptionsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetVisuals": {
                return Optional.ofNullable(clazz.cast(this.targetVisuals()));
            }
            case "TargetVisualOptions": {
                return Optional.ofNullable(clazz.cast(this.targetVisualOptionsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SameSheetTargetVisualConfiguration, T> g) {
        return obj -> g.apply((SameSheetTargetVisualConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> targetVisuals = DefaultSdkAutoConstructList.getInstance();
        private String targetVisualOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(SameSheetTargetVisualConfiguration model) {
            this.targetVisuals(model.targetVisuals);
            this.targetVisualOptions(model.targetVisualOptions);
        }

        public final Collection<String> getTargetVisuals() {
            if (this.targetVisuals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetVisuals;
        }

        public final void setTargetVisuals(Collection<String> targetVisuals) {
            this.targetVisuals = TargetVisualListCopier.copy(targetVisuals);
        }

        @Override
        public final Builder targetVisuals(Collection<String> targetVisuals) {
            this.targetVisuals = TargetVisualListCopier.copy(targetVisuals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetVisuals(String ... targetVisuals) {
            this.targetVisuals(Arrays.asList(targetVisuals));
            return this;
        }

        public final String getTargetVisualOptions() {
            return this.targetVisualOptions;
        }

        public final void setTargetVisualOptions(String targetVisualOptions) {
            this.targetVisualOptions = targetVisualOptions;
        }

        @Override
        public final Builder targetVisualOptions(String targetVisualOptions) {
            this.targetVisualOptions = targetVisualOptions;
            return this;
        }

        @Override
        public final Builder targetVisualOptions(TargetVisualOptions targetVisualOptions) {
            this.targetVisualOptions(targetVisualOptions == null ? null : targetVisualOptions.toString());
            return this;
        }

        public SameSheetTargetVisualConfiguration build() {
            return new SameSheetTargetVisualConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SameSheetTargetVisualConfiguration> {
        public Builder targetVisuals(Collection<String> var1);

        public Builder targetVisuals(String ... var1);

        public Builder targetVisualOptions(String var1);

        public Builder targetVisualOptions(TargetVisualOptions var1);
    }
}

