/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.quicksight.DefaultQuickSightBaseClientBuilder;
import software.amazon.awssdk.services.quicksight.DefaultQuickSightClient;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.QuickSightClientBuilder;
import software.amazon.awssdk.services.quicksight.QuickSightServiceClientConfiguration;
import software.amazon.awssdk.services.quicksight.endpoints.QuickSightEndpointProvider;

@SdkInternalApi
final class DefaultQuickSightClientBuilder
extends DefaultQuickSightBaseClientBuilder<QuickSightClientBuilder, QuickSightClient>
implements QuickSightClientBuilder {
    DefaultQuickSightClientBuilder() {
    }

    @Override
    public DefaultQuickSightClientBuilder endpointProvider(QuickSightEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final QuickSightClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultQuickSightClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        QuickSightServiceClientConfiguration serviceClientConfiguration = QuickSightServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultQuickSightClient(serviceClientConfiguration, clientConfiguration);
    }
}

