/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.model.DashboardSummary;
import software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDashboardsResponse;

public class ListDashboardsIterable
implements SdkIterable<ListDashboardsResponse> {
    private final QuickSightClient client;
    private final ListDashboardsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDashboardsIterable(QuickSightClient client, ListDashboardsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDashboardsResponseFetcher();
    }

    public Iterator<ListDashboardsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DashboardSummary> dashboardSummaryList() {
        Function<ListDashboardsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dashboardSummaryList() != null) {
                return response.dashboardSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDashboardsResponseFetcher
    implements SyncPageFetcher<ListDashboardsResponse> {
        private ListDashboardsResponseFetcher() {
        }

        public boolean hasNextPage(ListDashboardsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDashboardsResponse nextPage(ListDashboardsResponse previousPage) {
            if (previousPage == null) {
                return ListDashboardsIterable.this.client.listDashboards(ListDashboardsIterable.this.firstRequest);
            }
            return ListDashboardsIterable.this.client.listDashboards((ListDashboardsRequest)((Object)ListDashboardsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

