/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.CategoryFilterConfiguration;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CategoryFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CategoryFilter> {
    private static final SdkField<String> FILTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterId").getter(CategoryFilter.getter(CategoryFilter::filterId)).setter(CategoryFilter.setter(Builder::filterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterId").build()}).build();
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Column").getter(CategoryFilter.getter(CategoryFilter::column)).setter(CategoryFilter.setter(Builder::column)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<CategoryFilterConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(CategoryFilter.getter(CategoryFilter::configuration)).setter(CategoryFilter.setter(Builder::configuration)).constructor(CategoryFilterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_ID_FIELD, COLUMN_FIELD, CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String filterId;
    private final ColumnIdentifier column;
    private final CategoryFilterConfiguration configuration;

    private CategoryFilter(BuilderImpl builder) {
        this.filterId = builder.filterId;
        this.column = builder.column;
        this.configuration = builder.configuration;
    }

    public final String filterId() {
        return this.filterId;
    }

    public final ColumnIdentifier column() {
        return this.column;
    }

    public final CategoryFilterConfiguration configuration() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryFilter)) {
            return false;
        }
        CategoryFilter other = (CategoryFilter)obj;
        return Objects.equals(this.filterId(), other.filterId()) && Objects.equals(this.column(), other.column()) && Objects.equals(this.configuration(), other.configuration());
    }

    public final String toString() {
        return ToString.builder((String)"CategoryFilter").add("FilterId", (Object)this.filterId()).add("Column", (Object)this.column()).add("Configuration", (Object)this.configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterId": {
                return Optional.ofNullable(clazz.cast(this.filterId()));
            }
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CategoryFilter, T> g) {
        return obj -> g.apply((CategoryFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterId;
        private ColumnIdentifier column;
        private CategoryFilterConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(CategoryFilter model) {
            this.filterId(model.filterId);
            this.column(model.column);
            this.configuration(model.configuration);
        }

        public final String getFilterId() {
            return this.filterId;
        }

        public final void setFilterId(String filterId) {
            this.filterId = filterId;
        }

        @Override
        public final Builder filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return this.column != null ? this.column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final CategoryFilterConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(CategoryFilterConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CategoryFilterConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public CategoryFilter build() {
            return new CategoryFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CategoryFilter> {
        public Builder filterId(String var1);

        public Builder column(ColumnIdentifier var1);

        default public Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return this.column((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(column)).build());
        }

        public Builder configuration(CategoryFilterConfiguration var1);

        default public Builder configuration(Consumer<CategoryFilterConfiguration.Builder> configuration) {
            return this.configuration((CategoryFilterConfiguration)((CategoryFilterConfiguration.Builder)CategoryFilterConfiguration.builder().applyMutation(configuration)).build());
        }
    }
}

