/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.GeospatialCoordinateBounds;
import software.amazon.awssdk.services.quicksight.model.MapZoomMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeospatialWindowOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeospatialWindowOptions> {
    private static final SdkField<GeospatialCoordinateBounds> BOUNDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Bounds").getter(GeospatialWindowOptions.getter(GeospatialWindowOptions::bounds)).setter(GeospatialWindowOptions.setter(Builder::bounds)).constructor(GeospatialCoordinateBounds::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bounds").build()}).build();
    private static final SdkField<String> MAP_ZOOM_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MapZoomMode").getter(GeospatialWindowOptions.getter(GeospatialWindowOptions::mapZoomModeAsString)).setter(GeospatialWindowOptions.setter(Builder::mapZoomMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapZoomMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDS_FIELD, MAP_ZOOM_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final GeospatialCoordinateBounds bounds;
    private final String mapZoomMode;

    private GeospatialWindowOptions(BuilderImpl builder) {
        this.bounds = builder.bounds;
        this.mapZoomMode = builder.mapZoomMode;
    }

    public final GeospatialCoordinateBounds bounds() {
        return this.bounds;
    }

    public final MapZoomMode mapZoomMode() {
        return MapZoomMode.fromValue(this.mapZoomMode);
    }

    public final String mapZoomModeAsString() {
        return this.mapZoomMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bounds());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapZoomModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialWindowOptions)) {
            return false;
        }
        GeospatialWindowOptions other = (GeospatialWindowOptions)obj;
        return Objects.equals(this.bounds(), other.bounds()) && Objects.equals(this.mapZoomModeAsString(), other.mapZoomModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GeospatialWindowOptions").add("Bounds", (Object)this.bounds()).add("MapZoomMode", (Object)this.mapZoomModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bounds": {
                return Optional.ofNullable(clazz.cast(this.bounds()));
            }
            case "MapZoomMode": {
                return Optional.ofNullable(clazz.cast(this.mapZoomModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeospatialWindowOptions, T> g) {
        return obj -> g.apply((GeospatialWindowOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GeospatialCoordinateBounds bounds;
        private String mapZoomMode;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialWindowOptions model) {
            this.bounds(model.bounds);
            this.mapZoomMode(model.mapZoomMode);
        }

        public final GeospatialCoordinateBounds.Builder getBounds() {
            return this.bounds != null ? this.bounds.toBuilder() : null;
        }

        public final void setBounds(GeospatialCoordinateBounds.BuilderImpl bounds) {
            this.bounds = bounds != null ? bounds.build() : null;
        }

        @Override
        public final Builder bounds(GeospatialCoordinateBounds bounds) {
            this.bounds = bounds;
            return this;
        }

        public final String getMapZoomMode() {
            return this.mapZoomMode;
        }

        public final void setMapZoomMode(String mapZoomMode) {
            this.mapZoomMode = mapZoomMode;
        }

        @Override
        public final Builder mapZoomMode(String mapZoomMode) {
            this.mapZoomMode = mapZoomMode;
            return this;
        }

        @Override
        public final Builder mapZoomMode(MapZoomMode mapZoomMode) {
            this.mapZoomMode(mapZoomMode == null ? null : mapZoomMode.toString());
            return this;
        }

        public GeospatialWindowOptions build() {
            return new GeospatialWindowOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeospatialWindowOptions> {
        public Builder bounds(GeospatialCoordinateBounds var1);

        default public Builder bounds(Consumer<GeospatialCoordinateBounds.Builder> bounds) {
            return this.bounds((GeospatialCoordinateBounds)((GeospatialCoordinateBounds.Builder)GeospatialCoordinateBounds.builder().applyMutation(bounds)).build());
        }

        public Builder mapZoomMode(String var1);

        public Builder mapZoomMode(MapZoomMode var1);
    }
}

