/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DimensionField;
import software.amazon.awssdk.services.quicksight.model.MeasureField;
import software.amazon.awssdk.services.quicksight.model.WordCloudDimensionFieldListCopier;
import software.amazon.awssdk.services.quicksight.model.WordCloudMeasureFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WordCloudAggregatedFieldWells
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WordCloudAggregatedFieldWells> {
    private static final SdkField<List<DimensionField>> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupBy").getter(WordCloudAggregatedFieldWells.getter(WordCloudAggregatedFieldWells::groupBy)).setter(WordCloudAggregatedFieldWells.setter(Builder::groupBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DimensionField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MeasureField>> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Size").getter(WordCloudAggregatedFieldWells.getter(WordCloudAggregatedFieldWells::size)).setter(WordCloudAggregatedFieldWells.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MeasureField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_BY_FIELD, SIZE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<DimensionField> groupBy;
    private final List<MeasureField> size;

    private WordCloudAggregatedFieldWells(BuilderImpl builder) {
        this.groupBy = builder.groupBy;
        this.size = builder.size;
    }

    public final boolean hasGroupBy() {
        return this.groupBy != null && !(this.groupBy instanceof SdkAutoConstructList);
    }

    public final List<DimensionField> groupBy() {
        return this.groupBy;
    }

    public final boolean hasSize() {
        return this.size != null && !(this.size instanceof SdkAutoConstructList);
    }

    public final List<MeasureField> size() {
        return this.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupBy() ? this.groupBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSize() ? this.size() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WordCloudAggregatedFieldWells)) {
            return false;
        }
        WordCloudAggregatedFieldWells other = (WordCloudAggregatedFieldWells)obj;
        return this.hasGroupBy() == other.hasGroupBy() && Objects.equals(this.groupBy(), other.groupBy()) && this.hasSize() == other.hasSize() && Objects.equals(this.size(), other.size());
    }

    public final String toString() {
        return ToString.builder((String)"WordCloudAggregatedFieldWells").add("GroupBy", this.hasGroupBy() ? this.groupBy() : null).add("Size", this.hasSize() ? this.size() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupBy": {
                return Optional.ofNullable(clazz.cast(this.groupBy()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WordCloudAggregatedFieldWells, T> g) {
        return obj -> g.apply((WordCloudAggregatedFieldWells)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DimensionField> groupBy = DefaultSdkAutoConstructList.getInstance();
        private List<MeasureField> size = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WordCloudAggregatedFieldWells model) {
            this.groupBy(model.groupBy);
            this.size(model.size);
        }

        public final List<DimensionField.Builder> getGroupBy() {
            List<DimensionField.Builder> result = WordCloudDimensionFieldListCopier.copyToBuilder(this.groupBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupBy(Collection<DimensionField.BuilderImpl> groupBy) {
            this.groupBy = WordCloudDimensionFieldListCopier.copyFromBuilder(groupBy);
        }

        @Override
        public final Builder groupBy(Collection<DimensionField> groupBy) {
            this.groupBy = WordCloudDimensionFieldListCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(DimensionField ... groupBy) {
            this.groupBy(Arrays.asList(groupBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(Consumer<DimensionField.Builder> ... groupBy) {
            this.groupBy(Stream.of(groupBy).map(c -> (DimensionField)((DimensionField.Builder)DimensionField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getSize() {
            List<MeasureField.Builder> result = WordCloudMeasureFieldListCopier.copyToBuilder(this.size);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSize(Collection<MeasureField.BuilderImpl> size) {
            this.size = WordCloudMeasureFieldListCopier.copyFromBuilder(size);
        }

        @Override
        public final Builder size(Collection<MeasureField> size) {
            this.size = WordCloudMeasureFieldListCopier.copy(size);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder size(MeasureField ... size) {
            this.size(Arrays.asList(size));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder size(Consumer<MeasureField.Builder> ... size) {
            this.size(Stream.of(size).map(c -> (MeasureField)((MeasureField.Builder)MeasureField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public WordCloudAggregatedFieldWells build() {
            return new WordCloudAggregatedFieldWells(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WordCloudAggregatedFieldWells> {
        public Builder groupBy(Collection<DimensionField> var1);

        public Builder groupBy(DimensionField ... var1);

        public Builder groupBy(Consumer<DimensionField.Builder> ... var1);

        public Builder size(Collection<MeasureField> var1);

        public Builder size(MeasureField ... var1);

        public Builder size(Consumer<MeasureField.Builder> ... var1);
    }
}

