/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.TableFieldOptions;
import software.amazon.awssdk.services.quicksight.model.TableFieldWells;
import software.amazon.awssdk.services.quicksight.model.TableOptions;
import software.amazon.awssdk.services.quicksight.model.TablePaginatedReportOptions;
import software.amazon.awssdk.services.quicksight.model.TableSortConfiguration;
import software.amazon.awssdk.services.quicksight.model.TotalOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableConfiguration> {
    private static final SdkField<TableFieldWells> FIELD_WELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldWells").getter(TableConfiguration.getter(TableConfiguration::fieldWells)).setter(TableConfiguration.setter(Builder::fieldWells)).constructor(TableFieldWells::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()}).build();
    private static final SdkField<TableSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortConfiguration").getter(TableConfiguration.getter(TableConfiguration::sortConfiguration)).setter(TableConfiguration.setter(Builder::sortConfiguration)).constructor(TableSortConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()}).build();
    private static final SdkField<TableOptions> TABLE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TableOptions").getter(TableConfiguration.getter(TableConfiguration::tableOptions)).setter(TableConfiguration.setter(Builder::tableOptions)).constructor(TableOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableOptions").build()}).build();
    private static final SdkField<TotalOptions> TOTAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TotalOptions").getter(TableConfiguration.getter(TableConfiguration::totalOptions)).setter(TableConfiguration.setter(Builder::totalOptions)).constructor(TotalOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalOptions").build()}).build();
    private static final SdkField<TableFieldOptions> FIELD_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldOptions").getter(TableConfiguration.getter(TableConfiguration::fieldOptions)).setter(TableConfiguration.setter(Builder::fieldOptions)).constructor(TableFieldOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldOptions").build()}).build();
    private static final SdkField<TablePaginatedReportOptions> PAGINATED_REPORT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PaginatedReportOptions").getter(TableConfiguration.getter(TableConfiguration::paginatedReportOptions)).setter(TableConfiguration.setter(Builder::paginatedReportOptions)).constructor(TablePaginatedReportOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginatedReportOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD, SORT_CONFIGURATION_FIELD, TABLE_OPTIONS_FIELD, TOTAL_OPTIONS_FIELD, FIELD_OPTIONS_FIELD, PAGINATED_REPORT_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final TableFieldWells fieldWells;
    private final TableSortConfiguration sortConfiguration;
    private final TableOptions tableOptions;
    private final TotalOptions totalOptions;
    private final TableFieldOptions fieldOptions;
    private final TablePaginatedReportOptions paginatedReportOptions;

    private TableConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.tableOptions = builder.tableOptions;
        this.totalOptions = builder.totalOptions;
        this.fieldOptions = builder.fieldOptions;
        this.paginatedReportOptions = builder.paginatedReportOptions;
    }

    public final TableFieldWells fieldWells() {
        return this.fieldWells;
    }

    public final TableSortConfiguration sortConfiguration() {
        return this.sortConfiguration;
    }

    public final TableOptions tableOptions() {
        return this.tableOptions;
    }

    public final TotalOptions totalOptions() {
        return this.totalOptions;
    }

    public final TableFieldOptions fieldOptions() {
        return this.fieldOptions;
    }

    public final TablePaginatedReportOptions paginatedReportOptions() {
        return this.paginatedReportOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.paginatedReportOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableConfiguration)) {
            return false;
        }
        TableConfiguration other = (TableConfiguration)obj;
        return Objects.equals(this.fieldWells(), other.fieldWells()) && Objects.equals(this.sortConfiguration(), other.sortConfiguration()) && Objects.equals(this.tableOptions(), other.tableOptions()) && Objects.equals(this.totalOptions(), other.totalOptions()) && Objects.equals(this.fieldOptions(), other.fieldOptions()) && Objects.equals(this.paginatedReportOptions(), other.paginatedReportOptions());
    }

    public final String toString() {
        return ToString.builder((String)"TableConfiguration").add("FieldWells", (Object)this.fieldWells()).add("SortConfiguration", (Object)this.sortConfiguration()).add("TableOptions", (Object)this.tableOptions()).add("TotalOptions", (Object)this.totalOptions()).add("FieldOptions", (Object)this.fieldOptions()).add("PaginatedReportOptions", (Object)this.paginatedReportOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldWells": {
                return Optional.ofNullable(clazz.cast(this.fieldWells()));
            }
            case "SortConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sortConfiguration()));
            }
            case "TableOptions": {
                return Optional.ofNullable(clazz.cast(this.tableOptions()));
            }
            case "TotalOptions": {
                return Optional.ofNullable(clazz.cast(this.totalOptions()));
            }
            case "FieldOptions": {
                return Optional.ofNullable(clazz.cast(this.fieldOptions()));
            }
            case "PaginatedReportOptions": {
                return Optional.ofNullable(clazz.cast(this.paginatedReportOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableConfiguration, T> g) {
        return obj -> g.apply((TableConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TableFieldWells fieldWells;
        private TableSortConfiguration sortConfiguration;
        private TableOptions tableOptions;
        private TotalOptions totalOptions;
        private TableFieldOptions fieldOptions;
        private TablePaginatedReportOptions paginatedReportOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(TableConfiguration model) {
            this.fieldWells(model.fieldWells);
            this.sortConfiguration(model.sortConfiguration);
            this.tableOptions(model.tableOptions);
            this.totalOptions(model.totalOptions);
            this.fieldOptions(model.fieldOptions);
            this.paginatedReportOptions(model.paginatedReportOptions);
        }

        public final TableFieldWells.Builder getFieldWells() {
            return this.fieldWells != null ? this.fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(TableFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(TableFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final TableSortConfiguration.Builder getSortConfiguration() {
            return this.sortConfiguration != null ? this.sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(TableSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(TableSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final TableOptions.Builder getTableOptions() {
            return this.tableOptions != null ? this.tableOptions.toBuilder() : null;
        }

        public final void setTableOptions(TableOptions.BuilderImpl tableOptions) {
            this.tableOptions = tableOptions != null ? tableOptions.build() : null;
        }

        @Override
        public final Builder tableOptions(TableOptions tableOptions) {
            this.tableOptions = tableOptions;
            return this;
        }

        public final TotalOptions.Builder getTotalOptions() {
            return this.totalOptions != null ? this.totalOptions.toBuilder() : null;
        }

        public final void setTotalOptions(TotalOptions.BuilderImpl totalOptions) {
            this.totalOptions = totalOptions != null ? totalOptions.build() : null;
        }

        @Override
        public final Builder totalOptions(TotalOptions totalOptions) {
            this.totalOptions = totalOptions;
            return this;
        }

        public final TableFieldOptions.Builder getFieldOptions() {
            return this.fieldOptions != null ? this.fieldOptions.toBuilder() : null;
        }

        public final void setFieldOptions(TableFieldOptions.BuilderImpl fieldOptions) {
            this.fieldOptions = fieldOptions != null ? fieldOptions.build() : null;
        }

        @Override
        public final Builder fieldOptions(TableFieldOptions fieldOptions) {
            this.fieldOptions = fieldOptions;
            return this;
        }

        public final TablePaginatedReportOptions.Builder getPaginatedReportOptions() {
            return this.paginatedReportOptions != null ? this.paginatedReportOptions.toBuilder() : null;
        }

        public final void setPaginatedReportOptions(TablePaginatedReportOptions.BuilderImpl paginatedReportOptions) {
            this.paginatedReportOptions = paginatedReportOptions != null ? paginatedReportOptions.build() : null;
        }

        @Override
        public final Builder paginatedReportOptions(TablePaginatedReportOptions paginatedReportOptions) {
            this.paginatedReportOptions = paginatedReportOptions;
            return this;
        }

        public TableConfiguration build() {
            return new TableConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableConfiguration> {
        public Builder fieldWells(TableFieldWells var1);

        default public Builder fieldWells(Consumer<TableFieldWells.Builder> fieldWells) {
            return this.fieldWells((TableFieldWells)((TableFieldWells.Builder)TableFieldWells.builder().applyMutation(fieldWells)).build());
        }

        public Builder sortConfiguration(TableSortConfiguration var1);

        default public Builder sortConfiguration(Consumer<TableSortConfiguration.Builder> sortConfiguration) {
            return this.sortConfiguration((TableSortConfiguration)((TableSortConfiguration.Builder)TableSortConfiguration.builder().applyMutation(sortConfiguration)).build());
        }

        public Builder tableOptions(TableOptions var1);

        default public Builder tableOptions(Consumer<TableOptions.Builder> tableOptions) {
            return this.tableOptions((TableOptions)((TableOptions.Builder)TableOptions.builder().applyMutation(tableOptions)).build());
        }

        public Builder totalOptions(TotalOptions var1);

        default public Builder totalOptions(Consumer<TotalOptions.Builder> totalOptions) {
            return this.totalOptions((TotalOptions)((TotalOptions.Builder)TotalOptions.builder().applyMutation(totalOptions)).build());
        }

        public Builder fieldOptions(TableFieldOptions var1);

        default public Builder fieldOptions(Consumer<TableFieldOptions.Builder> fieldOptions) {
            return this.fieldOptions((TableFieldOptions)((TableFieldOptions.Builder)TableFieldOptions.builder().applyMutation(fieldOptions)).build());
        }

        public Builder paginatedReportOptions(TablePaginatedReportOptions var1);

        default public Builder paginatedReportOptions(Consumer<TablePaginatedReportOptions.Builder> paginatedReportOptions) {
            return this.paginatedReportOptions((TablePaginatedReportOptions)((TablePaginatedReportOptions.Builder)TablePaginatedReportOptions.builder().applyMutation(paginatedReportOptions)).build());
        }
    }
}

