/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DimensionField;
import software.amazon.awssdk.services.quicksight.model.ForecastComputationSeasonality;
import software.amazon.awssdk.services.quicksight.model.MeasureField;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ForecastComputation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ForecastComputation> {
    private static final SdkField<String> COMPUTATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputationId").getter(ForecastComputation.getter(ForecastComputation::computationId)).setter(ForecastComputation.setter(Builder::computationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ForecastComputation.getter(ForecastComputation::name)).setter(ForecastComputation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<DimensionField> TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Time").getter(ForecastComputation.getter(ForecastComputation::time)).setter(ForecastComputation.setter(Builder::time)).constructor(DimensionField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()}).build();
    private static final SdkField<MeasureField> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Value").getter(ForecastComputation.getter(ForecastComputation::value)).setter(ForecastComputation.setter(Builder::value)).constructor(MeasureField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Integer> PERIODS_FORWARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PeriodsForward").getter(ForecastComputation.getter(ForecastComputation::periodsForward)).setter(ForecastComputation.setter(Builder::periodsForward)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodsForward").build()}).build();
    private static final SdkField<Integer> PERIODS_BACKWARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PeriodsBackward").getter(ForecastComputation.getter(ForecastComputation::periodsBackward)).setter(ForecastComputation.setter(Builder::periodsBackward)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodsBackward").build()}).build();
    private static final SdkField<Double> UPPER_BOUNDARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("UpperBoundary").getter(ForecastComputation.getter(ForecastComputation::upperBoundary)).setter(ForecastComputation.setter(Builder::upperBoundary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpperBoundary").build()}).build();
    private static final SdkField<Double> LOWER_BOUNDARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("LowerBoundary").getter(ForecastComputation.getter(ForecastComputation::lowerBoundary)).setter(ForecastComputation.setter(Builder::lowerBoundary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowerBoundary").build()}).build();
    private static final SdkField<Integer> PREDICTION_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PredictionInterval").getter(ForecastComputation.getter(ForecastComputation::predictionInterval)).setter(ForecastComputation.setter(Builder::predictionInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictionInterval").build()}).build();
    private static final SdkField<String> SEASONALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Seasonality").getter(ForecastComputation.getter(ForecastComputation::seasonalityAsString)).setter(ForecastComputation.setter(Builder::seasonality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Seasonality").build()}).build();
    private static final SdkField<Integer> CUSTOM_SEASONALITY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CustomSeasonalityValue").getter(ForecastComputation.getter(ForecastComputation::customSeasonalityValue)).setter(ForecastComputation.setter(Builder::customSeasonalityValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomSeasonalityValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_ID_FIELD, NAME_FIELD, TIME_FIELD, VALUE_FIELD, PERIODS_FORWARD_FIELD, PERIODS_BACKWARD_FIELD, UPPER_BOUNDARY_FIELD, LOWER_BOUNDARY_FIELD, PREDICTION_INTERVAL_FIELD, SEASONALITY_FIELD, CUSTOM_SEASONALITY_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String computationId;
    private final String name;
    private final DimensionField time;
    private final MeasureField value;
    private final Integer periodsForward;
    private final Integer periodsBackward;
    private final Double upperBoundary;
    private final Double lowerBoundary;
    private final Integer predictionInterval;
    private final String seasonality;
    private final Integer customSeasonalityValue;

    private ForecastComputation(BuilderImpl builder) {
        this.computationId = builder.computationId;
        this.name = builder.name;
        this.time = builder.time;
        this.value = builder.value;
        this.periodsForward = builder.periodsForward;
        this.periodsBackward = builder.periodsBackward;
        this.upperBoundary = builder.upperBoundary;
        this.lowerBoundary = builder.lowerBoundary;
        this.predictionInterval = builder.predictionInterval;
        this.seasonality = builder.seasonality;
        this.customSeasonalityValue = builder.customSeasonalityValue;
    }

    public final String computationId() {
        return this.computationId;
    }

    public final String name() {
        return this.name;
    }

    public final DimensionField time() {
        return this.time;
    }

    public final MeasureField value() {
        return this.value;
    }

    public final Integer periodsForward() {
        return this.periodsForward;
    }

    public final Integer periodsBackward() {
        return this.periodsBackward;
    }

    public final Double upperBoundary() {
        return this.upperBoundary;
    }

    public final Double lowerBoundary() {
        return this.lowerBoundary;
    }

    public final Integer predictionInterval() {
        return this.predictionInterval;
    }

    public final ForecastComputationSeasonality seasonality() {
        return ForecastComputationSeasonality.fromValue(this.seasonality);
    }

    public final String seasonalityAsString() {
        return this.seasonality;
    }

    public final Integer customSeasonalityValue() {
        return this.customSeasonalityValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.computationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.time());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodsForward());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodsBackward());
        hashCode = 31 * hashCode + Objects.hashCode(this.upperBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(this.lowerBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.seasonalityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customSeasonalityValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastComputation)) {
            return false;
        }
        ForecastComputation other = (ForecastComputation)obj;
        return Objects.equals(this.computationId(), other.computationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.time(), other.time()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.periodsForward(), other.periodsForward()) && Objects.equals(this.periodsBackward(), other.periodsBackward()) && Objects.equals(this.upperBoundary(), other.upperBoundary()) && Objects.equals(this.lowerBoundary(), other.lowerBoundary()) && Objects.equals(this.predictionInterval(), other.predictionInterval()) && Objects.equals(this.seasonalityAsString(), other.seasonalityAsString()) && Objects.equals(this.customSeasonalityValue(), other.customSeasonalityValue());
    }

    public final String toString() {
        return ToString.builder((String)"ForecastComputation").add("ComputationId", (Object)this.computationId()).add("Name", (Object)this.name()).add("Time", (Object)this.time()).add("Value", (Object)this.value()).add("PeriodsForward", (Object)this.periodsForward()).add("PeriodsBackward", (Object)this.periodsBackward()).add("UpperBoundary", (Object)this.upperBoundary()).add("LowerBoundary", (Object)this.lowerBoundary()).add("PredictionInterval", (Object)this.predictionInterval()).add("Seasonality", (Object)this.seasonalityAsString()).add("CustomSeasonalityValue", (Object)this.customSeasonalityValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComputationId": {
                return Optional.ofNullable(clazz.cast(this.computationId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Time": {
                return Optional.ofNullable(clazz.cast(this.time()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "PeriodsForward": {
                return Optional.ofNullable(clazz.cast(this.periodsForward()));
            }
            case "PeriodsBackward": {
                return Optional.ofNullable(clazz.cast(this.periodsBackward()));
            }
            case "UpperBoundary": {
                return Optional.ofNullable(clazz.cast(this.upperBoundary()));
            }
            case "LowerBoundary": {
                return Optional.ofNullable(clazz.cast(this.lowerBoundary()));
            }
            case "PredictionInterval": {
                return Optional.ofNullable(clazz.cast(this.predictionInterval()));
            }
            case "Seasonality": {
                return Optional.ofNullable(clazz.cast(this.seasonalityAsString()));
            }
            case "CustomSeasonalityValue": {
                return Optional.ofNullable(clazz.cast(this.customSeasonalityValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ForecastComputation, T> g) {
        return obj -> g.apply((ForecastComputation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String computationId;
        private String name;
        private DimensionField time;
        private MeasureField value;
        private Integer periodsForward;
        private Integer periodsBackward;
        private Double upperBoundary;
        private Double lowerBoundary;
        private Integer predictionInterval;
        private String seasonality;
        private Integer customSeasonalityValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ForecastComputation model) {
            this.computationId(model.computationId);
            this.name(model.name);
            this.time(model.time);
            this.value(model.value);
            this.periodsForward(model.periodsForward);
            this.periodsBackward(model.periodsBackward);
            this.upperBoundary(model.upperBoundary);
            this.lowerBoundary(model.lowerBoundary);
            this.predictionInterval(model.predictionInterval);
            this.seasonality(model.seasonality);
            this.customSeasonalityValue(model.customSeasonalityValue);
        }

        public final String getComputationId() {
            return this.computationId;
        }

        public final void setComputationId(String computationId) {
            this.computationId = computationId;
        }

        @Override
        public final Builder computationId(String computationId) {
            this.computationId = computationId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DimensionField.Builder getTime() {
            return this.time != null ? this.time.toBuilder() : null;
        }

        public final void setTime(DimensionField.BuilderImpl time) {
            this.time = time != null ? time.build() : null;
        }

        @Override
        public final Builder time(DimensionField time) {
            this.time = time;
            return this;
        }

        public final MeasureField.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(MeasureField.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(MeasureField value) {
            this.value = value;
            return this;
        }

        public final Integer getPeriodsForward() {
            return this.periodsForward;
        }

        public final void setPeriodsForward(Integer periodsForward) {
            this.periodsForward = periodsForward;
        }

        @Override
        public final Builder periodsForward(Integer periodsForward) {
            this.periodsForward = periodsForward;
            return this;
        }

        public final Integer getPeriodsBackward() {
            return this.periodsBackward;
        }

        public final void setPeriodsBackward(Integer periodsBackward) {
            this.periodsBackward = periodsBackward;
        }

        @Override
        public final Builder periodsBackward(Integer periodsBackward) {
            this.periodsBackward = periodsBackward;
            return this;
        }

        public final Double getUpperBoundary() {
            return this.upperBoundary;
        }

        public final void setUpperBoundary(Double upperBoundary) {
            this.upperBoundary = upperBoundary;
        }

        @Override
        public final Builder upperBoundary(Double upperBoundary) {
            this.upperBoundary = upperBoundary;
            return this;
        }

        public final Double getLowerBoundary() {
            return this.lowerBoundary;
        }

        public final void setLowerBoundary(Double lowerBoundary) {
            this.lowerBoundary = lowerBoundary;
        }

        @Override
        public final Builder lowerBoundary(Double lowerBoundary) {
            this.lowerBoundary = lowerBoundary;
            return this;
        }

        public final Integer getPredictionInterval() {
            return this.predictionInterval;
        }

        public final void setPredictionInterval(Integer predictionInterval) {
            this.predictionInterval = predictionInterval;
        }

        @Override
        public final Builder predictionInterval(Integer predictionInterval) {
            this.predictionInterval = predictionInterval;
            return this;
        }

        public final String getSeasonality() {
            return this.seasonality;
        }

        public final void setSeasonality(String seasonality) {
            this.seasonality = seasonality;
        }

        @Override
        public final Builder seasonality(String seasonality) {
            this.seasonality = seasonality;
            return this;
        }

        @Override
        public final Builder seasonality(ForecastComputationSeasonality seasonality) {
            this.seasonality(seasonality == null ? null : seasonality.toString());
            return this;
        }

        public final Integer getCustomSeasonalityValue() {
            return this.customSeasonalityValue;
        }

        public final void setCustomSeasonalityValue(Integer customSeasonalityValue) {
            this.customSeasonalityValue = customSeasonalityValue;
        }

        @Override
        public final Builder customSeasonalityValue(Integer customSeasonalityValue) {
            this.customSeasonalityValue = customSeasonalityValue;
            return this;
        }

        public ForecastComputation build() {
            return new ForecastComputation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ForecastComputation> {
        public Builder computationId(String var1);

        public Builder name(String var1);

        public Builder time(DimensionField var1);

        default public Builder time(Consumer<DimensionField.Builder> time) {
            return this.time((DimensionField)((DimensionField.Builder)DimensionField.builder().applyMutation(time)).build());
        }

        public Builder value(MeasureField var1);

        default public Builder value(Consumer<MeasureField.Builder> value) {
            return this.value((MeasureField)((MeasureField.Builder)MeasureField.builder().applyMutation(value)).build());
        }

        public Builder periodsForward(Integer var1);

        public Builder periodsBackward(Integer var1);

        public Builder upperBoundary(Double var1);

        public Builder lowerBoundary(Double var1);

        public Builder predictionInterval(Integer var1);

        public Builder seasonality(String var1);

        public Builder seasonality(ForecastComputationSeasonality var1);

        public Builder customSeasonalityValue(Integer var1);
    }
}

