/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AggregationFunction;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.SortDirection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregationSortConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregationSortConfiguration> {
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Column").getter(AggregationSortConfiguration.getter(AggregationSortConfiguration::column)).setter(AggregationSortConfiguration.setter(Builder::column)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<String> SORT_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortDirection").getter(AggregationSortConfiguration.getter(AggregationSortConfiguration::sortDirectionAsString)).setter(AggregationSortConfiguration.setter(Builder::sortDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortDirection").build()}).build();
    private static final SdkField<AggregationFunction> AGGREGATION_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AggregationFunction").getter(AggregationSortConfiguration.getter(AggregationSortConfiguration::aggregationFunction)).setter(AggregationSortConfiguration.setter(Builder::aggregationFunction)).constructor(AggregationFunction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD, SORT_DIRECTION_FIELD, AGGREGATION_FUNCTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final ColumnIdentifier column;
    private final String sortDirection;
    private final AggregationFunction aggregationFunction;

    private AggregationSortConfiguration(BuilderImpl builder) {
        this.column = builder.column;
        this.sortDirection = builder.sortDirection;
        this.aggregationFunction = builder.aggregationFunction;
    }

    public final ColumnIdentifier column() {
        return this.column;
    }

    public final SortDirection sortDirection() {
        return SortDirection.fromValue(this.sortDirection);
    }

    public final String sortDirectionAsString() {
        return this.sortDirection;
    }

    public final AggregationFunction aggregationFunction() {
        return this.aggregationFunction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationFunction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationSortConfiguration)) {
            return false;
        }
        AggregationSortConfiguration other = (AggregationSortConfiguration)obj;
        return Objects.equals(this.column(), other.column()) && Objects.equals(this.sortDirectionAsString(), other.sortDirectionAsString()) && Objects.equals(this.aggregationFunction(), other.aggregationFunction());
    }

    public final String toString() {
        return ToString.builder((String)"AggregationSortConfiguration").add("Column", (Object)this.column()).add("SortDirection", (Object)this.sortDirectionAsString()).add("AggregationFunction", (Object)this.aggregationFunction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "SortDirection": {
                return Optional.ofNullable(clazz.cast(this.sortDirectionAsString()));
            }
            case "AggregationFunction": {
                return Optional.ofNullable(clazz.cast(this.aggregationFunction()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregationSortConfiguration, T> g) {
        return obj -> g.apply((AggregationSortConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ColumnIdentifier column;
        private String sortDirection;
        private AggregationFunction aggregationFunction;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationSortConfiguration model) {
            this.column(model.column);
            this.sortDirection(model.sortDirection);
            this.aggregationFunction(model.aggregationFunction);
        }

        public final ColumnIdentifier.Builder getColumn() {
            return this.column != null ? this.column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final String getSortDirection() {
            return this.sortDirection;
        }

        public final void setSortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
        }

        @Override
        public final Builder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        @Override
        public final Builder sortDirection(SortDirection sortDirection) {
            this.sortDirection(sortDirection == null ? null : sortDirection.toString());
            return this;
        }

        public final AggregationFunction.Builder getAggregationFunction() {
            return this.aggregationFunction != null ? this.aggregationFunction.toBuilder() : null;
        }

        public final void setAggregationFunction(AggregationFunction.BuilderImpl aggregationFunction) {
            this.aggregationFunction = aggregationFunction != null ? aggregationFunction.build() : null;
        }

        @Override
        public final Builder aggregationFunction(AggregationFunction aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
            return this;
        }

        public AggregationSortConfiguration build() {
            return new AggregationSortConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregationSortConfiguration> {
        public Builder column(ColumnIdentifier var1);

        default public Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return this.column((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(column)).build());
        }

        public Builder sortDirection(String var1);

        public Builder sortDirection(SortDirection var1);

        public Builder aggregationFunction(AggregationFunction var1);

        default public Builder aggregationFunction(Consumer<AggregationFunction.Builder> aggregationFunction) {
            return this.aggregationFunction((AggregationFunction)((AggregationFunction.Builder)AggregationFunction.builder().applyMutation(aggregationFunction)).build());
        }
    }
}

