/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDashboardResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, CreateDashboardResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateDashboardResponse.getter(CreateDashboardResponse::arn)).setter(CreateDashboardResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionArn").getter(CreateDashboardResponse.getter(CreateDashboardResponse::versionArn)).setter(CreateDashboardResponse.setter(Builder::versionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionArn").build()}).build();
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardId").getter(CreateDashboardResponse.getter(CreateDashboardResponse::dashboardId)).setter(CreateDashboardResponse.setter(Builder::dashboardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardId").build()}).build();
    private static final SdkField<String> CREATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationStatus").getter(CreateDashboardResponse.getter(CreateDashboardResponse::creationStatusAsString)).setter(CreateDashboardResponse.setter(Builder::creationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationStatus").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(CreateDashboardResponse.getter(CreateDashboardResponse::status)).setter(CreateDashboardResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(CreateDashboardResponse.getter(CreateDashboardResponse::requestId)).setter(CreateDashboardResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, VERSION_ARN_FIELD, DASHBOARD_ID_FIELD, CREATION_STATUS_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private final String arn;
    private final String versionArn;
    private final String dashboardId;
    private final String creationStatus;
    private final Integer status;
    private final String requestId;

    private CreateDashboardResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.versionArn = builder.versionArn;
        this.dashboardId = builder.dashboardId;
        this.creationStatus = builder.creationStatus;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String versionArn() {
        return this.versionArn;
    }

    public final String dashboardId() {
        return this.dashboardId;
    }

    public final ResourceStatus creationStatus() {
        return ResourceStatus.fromValue(this.creationStatus);
    }

    public final String creationStatusAsString() {
        return this.creationStatus;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDashboardResponse)) {
            return false;
        }
        CreateDashboardResponse other = (CreateDashboardResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.versionArn(), other.versionArn()) && Objects.equals(this.dashboardId(), other.dashboardId()) && Objects.equals(this.creationStatusAsString(), other.creationStatusAsString()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDashboardResponse").add("Arn", (Object)this.arn()).add("VersionArn", (Object)this.versionArn()).add("DashboardId", (Object)this.dashboardId()).add("CreationStatus", (Object)this.creationStatusAsString()).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "VersionArn": {
                return Optional.ofNullable(clazz.cast(this.versionArn()));
            }
            case "DashboardId": {
                return Optional.ofNullable(clazz.cast(this.dashboardId()));
            }
            case "CreationStatus": {
                return Optional.ofNullable(clazz.cast(this.creationStatusAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDashboardResponse, T> g) {
        return obj -> g.apply((CreateDashboardResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String versionArn;
        private String dashboardId;
        private String creationStatus;
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDashboardResponse model) {
            super(model);
            this.arn(model.arn);
            this.versionArn(model.versionArn);
            this.dashboardId(model.dashboardId);
            this.creationStatus(model.creationStatus);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getVersionArn() {
            return this.versionArn;
        }

        public final void setVersionArn(String versionArn) {
            this.versionArn = versionArn;
        }

        @Override
        public final Builder versionArn(String versionArn) {
            this.versionArn = versionArn;
            return this;
        }

        public final String getDashboardId() {
            return this.dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final String getCreationStatus() {
            return this.creationStatus;
        }

        public final void setCreationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
        }

        @Override
        public final Builder creationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
            return this;
        }

        @Override
        public final Builder creationStatus(ResourceStatus creationStatus) {
            this.creationStatus(creationStatus == null ? null : creationStatus.toString());
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public CreateDashboardResponse build() {
            return new CreateDashboardResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDashboardResponse> {
        public Builder arn(String var1);

        public Builder versionArn(String var1);

        public Builder dashboardId(String var1);

        public Builder creationStatus(String var1);

        public Builder creationStatus(ResourceStatus var1);

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

