/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.BodySectionContent;
import software.amazon.awssdk.services.quicksight.model.SectionPageBreakConfiguration;
import software.amazon.awssdk.services.quicksight.model.SectionStyle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BodySectionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BodySectionConfiguration> {
    private static final SdkField<String> SECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SectionId").getter(BodySectionConfiguration.getter(BodySectionConfiguration::sectionId)).setter(BodySectionConfiguration.setter(Builder::sectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SectionId").build()}).build();
    private static final SdkField<BodySectionContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Content").getter(BodySectionConfiguration.getter(BodySectionConfiguration::content)).setter(BodySectionConfiguration.setter(Builder::content)).constructor(BodySectionContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<SectionStyle> STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Style").getter(BodySectionConfiguration.getter(BodySectionConfiguration::style)).setter(BodySectionConfiguration.setter(Builder::style)).constructor(SectionStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Style").build()}).build();
    private static final SdkField<SectionPageBreakConfiguration> PAGE_BREAK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PageBreakConfiguration").getter(BodySectionConfiguration.getter(BodySectionConfiguration::pageBreakConfiguration)).setter(BodySectionConfiguration.setter(Builder::pageBreakConfiguration)).constructor(SectionPageBreakConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageBreakConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECTION_ID_FIELD, CONTENT_FIELD, STYLE_FIELD, PAGE_BREAK_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sectionId;
    private final BodySectionContent content;
    private final SectionStyle style;
    private final SectionPageBreakConfiguration pageBreakConfiguration;

    private BodySectionConfiguration(BuilderImpl builder) {
        this.sectionId = builder.sectionId;
        this.content = builder.content;
        this.style = builder.style;
        this.pageBreakConfiguration = builder.pageBreakConfiguration;
    }

    public final String sectionId() {
        return this.sectionId;
    }

    public final BodySectionContent content() {
        return this.content;
    }

    public final SectionStyle style() {
        return this.style;
    }

    public final SectionPageBreakConfiguration pageBreakConfiguration() {
        return this.pageBreakConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.style());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageBreakConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BodySectionConfiguration)) {
            return false;
        }
        BodySectionConfiguration other = (BodySectionConfiguration)obj;
        return Objects.equals(this.sectionId(), other.sectionId()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.style(), other.style()) && Objects.equals(this.pageBreakConfiguration(), other.pageBreakConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"BodySectionConfiguration").add("SectionId", (Object)this.sectionId()).add("Content", (Object)this.content()).add("Style", (Object)this.style()).add("PageBreakConfiguration", (Object)this.pageBreakConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SectionId": {
                return Optional.ofNullable(clazz.cast(this.sectionId()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "Style": {
                return Optional.ofNullable(clazz.cast(this.style()));
            }
            case "PageBreakConfiguration": {
                return Optional.ofNullable(clazz.cast(this.pageBreakConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BodySectionConfiguration, T> g) {
        return obj -> g.apply((BodySectionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sectionId;
        private BodySectionContent content;
        private SectionStyle style;
        private SectionPageBreakConfiguration pageBreakConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(BodySectionConfiguration model) {
            this.sectionId(model.sectionId);
            this.content(model.content);
            this.style(model.style);
            this.pageBreakConfiguration(model.pageBreakConfiguration);
        }

        public final String getSectionId() {
            return this.sectionId;
        }

        public final void setSectionId(String sectionId) {
            this.sectionId = sectionId;
        }

        @Override
        public final Builder sectionId(String sectionId) {
            this.sectionId = sectionId;
            return this;
        }

        public final BodySectionContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(BodySectionContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(BodySectionContent content) {
            this.content = content;
            return this;
        }

        public final SectionStyle.Builder getStyle() {
            return this.style != null ? this.style.toBuilder() : null;
        }

        public final void setStyle(SectionStyle.BuilderImpl style) {
            this.style = style != null ? style.build() : null;
        }

        @Override
        public final Builder style(SectionStyle style) {
            this.style = style;
            return this;
        }

        public final SectionPageBreakConfiguration.Builder getPageBreakConfiguration() {
            return this.pageBreakConfiguration != null ? this.pageBreakConfiguration.toBuilder() : null;
        }

        public final void setPageBreakConfiguration(SectionPageBreakConfiguration.BuilderImpl pageBreakConfiguration) {
            this.pageBreakConfiguration = pageBreakConfiguration != null ? pageBreakConfiguration.build() : null;
        }

        @Override
        public final Builder pageBreakConfiguration(SectionPageBreakConfiguration pageBreakConfiguration) {
            this.pageBreakConfiguration = pageBreakConfiguration;
            return this;
        }

        public BodySectionConfiguration build() {
            return new BodySectionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BodySectionConfiguration> {
        public Builder sectionId(String var1);

        public Builder content(BodySectionContent var1);

        default public Builder content(Consumer<BodySectionContent.Builder> content) {
            return this.content((BodySectionContent)((BodySectionContent.Builder)BodySectionContent.builder().applyMutation(content)).build());
        }

        public Builder style(SectionStyle var1);

        default public Builder style(Consumer<SectionStyle.Builder> style) {
            return this.style((SectionStyle)((SectionStyle.Builder)SectionStyle.builder().applyMutation(style)).build());
        }

        public Builder pageBreakConfiguration(SectionPageBreakConfiguration var1);

        default public Builder pageBreakConfiguration(Consumer<SectionPageBreakConfiguration.Builder> pageBreakConfiguration) {
            return this.pageBreakConfiguration((SectionPageBreakConfiguration)((SectionPageBreakConfiguration.Builder)SectionPageBreakConfiguration.builder().applyMutation(pageBreakConfiguration)).build());
        }
    }
}

