/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuthenticationMethodOption {
    IAM_AND_QUICKSIGHT("IAM_AND_QUICKSIGHT"),
    IAM_ONLY("IAM_ONLY"),
    ACTIVE_DIRECTORY("ACTIVE_DIRECTORY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuthenticationMethodOption> VALUE_MAP;
    private final String value;

    private AuthenticationMethodOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthenticationMethodOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthenticationMethodOption> knownValues() {
        EnumSet<AuthenticationMethodOption> knownValues = EnumSet.allOf(AuthenticationMethodOption.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuthenticationMethodOption.class, AuthenticationMethodOption::toString);
    }
}

