/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IngestionType {
    INCREMENTAL_REFRESH("INCREMENTAL_REFRESH"),
    FULL_REFRESH("FULL_REFRESH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IngestionType> VALUE_MAP;
    private final String value;

    private IngestionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IngestionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IngestionType> knownValues() {
        EnumSet<IngestionType> knownValues = EnumSet.allOf(IngestionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IngestionType.class, IngestionType::toString);
    }
}

